/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

public final class NBTCollectors {
    private static final Collector<INBT, ?, ListNBT> TO_TAG_LIST = NBTCollectors.toTagList(value -> value);
    private static final Collector<Long, ?, ListNBT> TO_LONG_TAG_LIST = NBTCollectors.toTagList(LongNBT::func_229698_a_);
    private static final Collector<Integer, ?, ListNBT> TO_INT_TAG_LIST = NBTCollectors.toTagList(IntNBT::func_229692_a_);
    private static final Collector<Byte, ?, ListNBT> TO_BYTE_TAG_LIST = NBTCollectors.toTagList(ByteNBT::func_229671_a_);
    private static final Collector<Short, ?, ListNBT> TO_SHORT_TAG_LIST = NBTCollectors.toTagList(ShortNBT::func_229701_a_);
    private static final Collector<Boolean, ?, ListNBT> TO_BOOLEAN_TAG_LIST = NBTCollectors.toTagList(ByteNBT::func_229672_a_);
    private static final Collector<Double, ?, ListNBT> TO_DOUBLE_TAG_LIST = NBTCollectors.toTagList(DoubleNBT::func_229684_a_);
    private static final Collector<Float, ?, ListNBT> TO_FLOAT_TAG_LIST = NBTCollectors.toTagList(FloatNBT::func_229689_a_);
    private static final Collector<String, ?, ListNBT> TO_STRING_TAG_LIST = NBTCollectors.toTagList(StringNBT::func_229705_a_);
    private static final Collector<INBT, ?, List<String>> TO_STRING_LIST = NBTCollectors.toList(INBT::func_150285_a_);

    private static <E> Collector<INBT, List<E>, List<E>> toList0(Function<INBT, E> toValueFunction) {
        return Collector.of(ArrayList::new, (list, value) -> list.add(toValueFunction.apply((INBT)value)), (first, second) -> {
            first.addAll(second);
            return first;
        }, list -> list, new Collector.Characteristics[0]);
    }

    public static <E> Collector<INBT, ?, List<E>> toList(Function<INBT, E> toValueFunction) {
        return NBTCollectors.toList0(toValueFunction);
    }

    public static <E> Collector<E, ?, ListNBT> toTagList(Function<E, INBT> toTagFunction) {
        return Collector.of(ListNBT::new, (list, value) -> list.add((Object)((INBT)toTagFunction.apply(value))), (first, second) -> {
            first.addAll((Collection)second);
            return first;
        }, list -> list, new Collector.Characteristics[0]);
    }

    public static Collector<INBT, ?, ListNBT> toTagList() {
        return TO_TAG_LIST;
    }

    public static Collector<Boolean, ?, ListNBT> toBooleanTagList() {
        return TO_BOOLEAN_TAG_LIST;
    }

    public static Collector<Byte, ?, ListNBT> toByteTagList() {
        return TO_BYTE_TAG_LIST;
    }

    public static Collector<Short, ?, ListNBT> toShortTagList() {
        return TO_SHORT_TAG_LIST;
    }

    public static Collector<Integer, ?, ListNBT> toIntTagList() {
        return TO_INT_TAG_LIST;
    }

    public static Collector<Long, ?, ListNBT> toLongTagList() {
        return TO_LONG_TAG_LIST;
    }

    public static Collector<Float, ?, ListNBT> toFloatTagList() {
        return TO_FLOAT_TAG_LIST;
    }

    public static Collector<Double, ?, ListNBT> toDoubleTagList() {
        return TO_DOUBLE_TAG_LIST;
    }

    public static Collector<String, ?, ListNBT> toStringTagList() {
        return TO_STRING_TAG_LIST;
    }

    public static Collector<INBT, ?, List<String>> toStringList() {
        return TO_STRING_LIST;
    }

    private NBTCollectors() {
    }
}

