/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.raytrace;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.raytrace.AbstractSpongeRayTrace;
import org.spongepowered.common.util.raytrace.SpongeRayTraceResult;

public final class SpongeEntityRayTrace
extends AbstractSpongeRayTrace<org.spongepowered.api.entity.Entity> {
    private static final Predicate<org.spongepowered.api.entity.Entity> DEFAULT_FILTER = entity -> true;

    public SpongeEntityRayTrace() {
        super(DEFAULT_FILTER);
    }

    @Override
    boolean requiresEntityTracking() {
        return true;
    }

    @Override
    List<Entity> selectEntities(ServerWorld serverWorld, AxisAlignedBB targetAABB) {
        return ((World)serverWorld).func_175674_a((Entity)null, targetAABB, this.select);
    }

    @Override
    final Optional<RayTraceResult<@NonNull org.spongepowered.api.entity.Entity>> testSelectLocation(ServerWorld serverWorld, Vector3d vec3din, Vector3d vec3dend) {
        double currentSqDist = Double.MAX_VALUE;
        SpongeRayTraceResult<org.spongepowered.api.entity.Entity> returnedEntity = null;
        LocatableBlock locatableBlock = this.getBlock(serverWorld, vec3din, vec3dend);
        for (Entity entity : this.selectEntities(serverWorld, this.getBlockAABB(locatableBlock.blockPosition()))) {
            Vector3d hitPosition;
            double sqdist;
            Optional vec3d = entity.func_174813_aQ().func_216365_b(vec3din, vec3dend);
            if (!vec3d.isPresent() || !((sqdist = (hitPosition = (Vector3d)vec3d.get()).func_72436_e(vec3din)) < currentSqDist)) continue;
            currentSqDist = sqdist;
            returnedEntity = new SpongeRayTraceResult<org.spongepowered.api.entity.Entity>((org.spongepowered.api.entity.Entity)entity, VecHelper.toVector3d(hitPosition));
        }
        return Optional.ofNullable(returnedEntity);
    }

    @Override
    final boolean shouldCheckFailures() {
        return true;
    }
}

