/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.provider.LayeredBiomeConfig;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.SeedUtil;
import org.spongepowered.common.world.biome.provider.AbstractBiomeProviderConfig;

public final class SpongeLayeredBiomeConfg
extends AbstractBiomeProviderConfig
implements LayeredBiomeConfig {
    private final long seed;
    private final boolean largeBiomes;

    protected SpongeLayeredBiomeConfg(BuilderImpl builder) {
        super(builder.biomes);
        this.seed = builder.seed;
        this.largeBiomes = builder.largeBiomes;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public boolean largeBiomes() {
        return this.largeBiomes;
    }

    public static final class BuilderImpl
    implements LayeredBiomeConfig.Builder {
        public List<RegistryReference<Biome>> biomes = new ArrayList<RegistryReference<Biome>>();
        public long seed;
        public boolean largeBiomes;

        @Override
        public LayeredBiomeConfig.Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public LayeredBiomeConfig.Builder seed(String seed) {
            this.seed = SeedUtil.compute(seed);
            return this;
        }

        @Override
        public LayeredBiomeConfig.Builder addBiome(RegistryReference<Biome> biome) {
            this.biomes.add(Objects.requireNonNull(biome, "biome"));
            return this;
        }

        @Override
        public LayeredBiomeConfig.Builder addBiomes(List<RegistryReference<Biome>> biomes) {
            this.biomes.addAll((Collection<RegistryReference<Biome>>)Objects.requireNonNull(biomes, "biomes"));
            return this;
        }

        @Override
        public LayeredBiomeConfig.Builder removeBiome(RegistryReference<Biome> biome) {
            Objects.requireNonNull(biome, "biome");
            Iterator<RegistryReference<Biome>> iter = this.biomes.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(biome)) continue;
                iter.remove();
                break;
            }
            return this;
        }

        @Override
        public LayeredBiomeConfig.Builder largeBiomes(boolean largeBiomes) {
            this.largeBiomes = largeBiomes;
            return this;
        }

        @Override
        public LayeredBiomeConfig.Builder from(LayeredBiomeConfig value) {
            this.seed = Objects.requireNonNull(value, "value").seed();
            return this;
        }

        @Override
        public LayeredBiomeConfig.Builder reset() {
            this.seed = BootstrapProperties.worldGenSettings.func_236221_b_();
            this.biomes.clear();
            this.largeBiomes = false;
            return this;
        }

        public @NonNull LayeredBiomeConfig build() {
            if (this.biomes.isEmpty()) {
                throw new IllegalStateException("Layered biome config requires at least one biome!");
            }
            return new SpongeLayeredBiomeConfg(this);
        }
    }
}

