/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config;

import java.util.Objects;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.api.world.generation.config.structure.StructureGenerationConfig;
import org.spongepowered.common.accessor.world.level.levelgen.NoiseGeneratorSettingsAccessor;

public final class SpongeNoiseGeneratorConfig {

    public static final class FactoryImpl
    implements NoiseGeneratorConfig.Factory {
        @Override
        public NoiseGeneratorConfig amplified() {
            return (NoiseGeneratorConfig)WorldGenRegistries.field_243658_j.func_230516_a_(DimensionSettings.field_242735_d);
        }

        @Override
        public NoiseGeneratorConfig overworld() {
            return (NoiseGeneratorConfig)WorldGenRegistries.field_243658_j.func_230516_a_(DimensionSettings.field_242734_c);
        }

        @Override
        public NoiseGeneratorConfig nether() {
            return (NoiseGeneratorConfig)WorldGenRegistries.field_243658_j.func_230516_a_(DimensionSettings.field_242736_e);
        }

        @Override
        public NoiseGeneratorConfig end() {
            return (NoiseGeneratorConfig)WorldGenRegistries.field_243658_j.func_230516_a_(DimensionSettings.field_242737_f);
        }

        @Override
        public NoiseGeneratorConfig caves() {
            return (NoiseGeneratorConfig)WorldGenRegistries.field_243658_j.func_230516_a_(DimensionSettings.field_242738_g);
        }

        @Override
        public NoiseGeneratorConfig floatingIslands() {
            return (NoiseGeneratorConfig)WorldGenRegistries.field_243658_j.func_230516_a_(DimensionSettings.field_242739_h);
        }
    }

    public static final class BuilderImpl
    implements NoiseGeneratorConfig.Builder {
        public StructureGenerationConfig structureConfig;
        public NoiseConfig noiseConfig;
        public BlockState defaultBlock;
        public BlockState defaultFluid;
        public int bedrockRoofY;
        public int bedrockFloorY;
        public int seaLevel;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseGeneratorConfig.Builder structureConfig(StructureGenerationConfig config) {
            this.structureConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder noiseConfig(NoiseConfig config) {
            this.noiseConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder defaultBlock(BlockState block) {
            this.defaultBlock = Objects.requireNonNull(block, "block");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder defaultFluid(BlockState fluid) {
            this.defaultFluid = Objects.requireNonNull(fluid, "fluid");
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder bedrockRoofY(int y) {
            this.bedrockRoofY = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder bedrockFloorY(int y) {
            this.bedrockFloorY = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder seaLevel(int y) {
            this.seaLevel = y;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder reset() {
            this.structureConfig = (StructureGenerationConfig)new DimensionStructuresSettings(true);
            this.noiseConfig = NoiseConfig.overworld();
            this.defaultBlock = (BlockState)BlockTypes.STONE.get().defaultState();
            this.defaultFluid = (BlockState)BlockTypes.WATER.get().defaultState();
            this.bedrockRoofY = -10;
            this.bedrockFloorY = 0;
            this.seaLevel = 63;
            return this;
        }

        @Override
        public NoiseGeneratorConfig.Builder from(NoiseGeneratorConfig value) {
            this.structureConfig = value.structureConfig();
            this.noiseConfig = value.noiseConfig();
            this.defaultBlock = value.defaultBlock();
            this.defaultFluid = value.defaultFluid();
            this.bedrockRoofY = value.bedrockRoofY();
            this.bedrockFloorY = value.bedrockFloorY();
            this.seaLevel = value.seaLevel();
            return this;
        }

        public NoiseGeneratorConfig build() {
            DimensionSettings settings = NoiseGeneratorSettingsAccessor.invoker$new((DimensionStructuresSettings)this.structureConfig, (NoiseSettings)this.noiseConfig, (net.minecraft.block.BlockState)this.defaultBlock, (net.minecraft.block.BlockState)this.defaultFluid, this.bedrockRoofY, this.bedrockFloorY, this.seaLevel, false);
            return (NoiseGeneratorConfig)settings;
        }
    }
}

