/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.schematic.ReferentSchematicVolume;
import org.spongepowered.common.world.volume.buffer.AbstractVolumeBuffer;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.math.vector.Vector3i;

public class SpongeSchematic
extends AbstractVolumeBuffer
implements Schematic {
    private final SpongeArchetypeVolume volume;
    private final DataView metadata;

    public SpongeSchematic(Vector3i start, Vector3i size, SpongeArchetypeVolume volume, DataView metadata) {
        super(start, size);
        this.volume = volume;
        this.metadata = metadata;
    }

    @Override
    public Palette<BlockState, BlockType> blockPalette() {
        return this.volume.getBlockPalette();
    }

    @Override
    public Palette<Biome, Biome> biomePalette() {
        return this.volume.getBiomePalette();
    }

    @Override
    public DataView metadata() {
        return this.metadata;
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
        this.volume.addBlockEntity(x, y, z, archetype);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.volume.removeBlockEntity(x, y, z);
    }

    @Override
    public Optional<BlockEntityArchetype> blockEntityArchetype(int x, int y, int z) {
        return this.volume.blockEntityArchetype(x, y, z);
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> blockEntityArchetypes() {
        return this.volume.blockEntityArchetypes();
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> blockEntityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.blockEntityArchetypeStream(min2, max, options);
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes() {
        return this.volume.entityArchetypes();
    }

    @Override
    public Collection<EntityArchetypeEntry> entityArchetypesByPosition() {
        return this.volume.entityArchetypesByPosition();
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> filter) {
        return this.volume.entityArchetypes(filter);
    }

    @Override
    public VolumeStream<ArchetypeVolume, EntityArchetype> entityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.entityArchetypeStream(min2, max, options);
    }

    @Override
    public Stream<EntityArchetypeEntry> entitiesByPosition() {
        return this.volume.entitiesByPosition();
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.volume.setBlock(x, y, z, block);
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return this.volume.removeBlock(x, y, z);
    }

    @Override
    public BlockState block(int x, int y, int z) {
        return this.volume.block(x, y, z);
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        return this.volume.fluid(x, y, z);
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.volume.highestYAt(x, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockState> blockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.blockStateStream(min2, max, options);
    }

    @Override
    public <E> Optional<E> get(int x, int y, int z, Key<? extends Value<E>> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).get(key), () -> this.fluid(x, y, z).get(key), () -> this.blockEntityArchetype(x, y, z).flatMap(archetype -> archetype.get(key)));
        return dataRetrievalStream.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(int x, int y, int z, Key<V> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).getValue(key), () -> this.fluid(x, y, z).getValue(key), () -> this.blockEntityArchetype(x, y, z).flatMap(archetype -> archetype.getValue(key)));
        return dataRetrievalStream.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public boolean supports(int x, int y, int z, Key<@NonNull ?> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).supports(key), () -> this.fluid(x, y, z).supports(key), () -> this.blockEntityArchetype(x, y, z).map(archetype -> archetype.supports(key)).orElse(false));
        return dataRetrievalStream.map(Supplier::get).filter(Boolean::booleanValue).findFirst().orElse(false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Set<Key<@NonNull ?>> keys(int x, int y, int z) {
        Stream<@NonNull Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).getKeys(), () -> this.fluid(x, y, z).getKeys(), () -> this.blockEntityArchetype(x, y, z).map(ValueContainer::getKeys).orElseGet(Collections::emptySet));
        return dataRetrievalStream.map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<Value.Immutable<?>> getValues(int x, int y, int z) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).getValues(), () -> this.fluid(x, y, z).getValues(), () -> this.blockEntityArchetype(x, y, z).map(ValueContainer::getValues).orElseGet(Collections::emptySet));
        return dataRetrievalStream.map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends Value<E>> key, E value) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).with(key, value).map(newState -> {
            Object newValue = newState.requireValue(key);
            this.setBlock(x, y, z, (BlockState)newState);
            return DataTransactionResult.successResult(newValue.asImmutable());
        }).orElseGet(DataTransactionResult::failNoData), () -> this.fluid(x, y, z).with(key, value).map(newState -> {
            Object newValue = newState.requireValue(key);
            this.setBlock(x, y, z, newState.block());
            return DataTransactionResult.successResult(newValue.asImmutable());
        }).orElseGet(DataTransactionResult::failNoData), () -> this.blockEntityArchetype(x, y, z).map(archetype -> archetype.offer(key, value)).orElseGet(DataTransactionResult::failNoData));
        return dataRetrievalStream.map(Supplier::get).filter(DataTransactionResult::isSuccessful).findFirst().orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Key<@NonNull ?> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.block(x, y, z).without(key).map(newState -> {
            Value.Immutable newValue = this.block(x, y, z).requireValue(key).asImmutable();
            this.setBlock(x, y, z, (BlockState)newState);
            return DataTransactionResult.successResult(newValue);
        }).orElseGet(DataTransactionResult::failNoData), () -> this.fluid(x, y, z).without(key).map(newState -> {
            Value.Immutable newValue = this.fluid(x, y, z).requireValue(key).asImmutable();
            this.setBlock(x, y, z, newState.block());
            return DataTransactionResult.successResult(newValue);
        }).orElseGet(DataTransactionResult::failNoData), () -> this.blockEntityArchetype(x, y, z).map(archetype -> archetype.remove(key)).orElseGet(DataTransactionResult::failNoData));
        return dataRetrievalStream.map(Supplier::get).filter(DataTransactionResult::isSuccessful).findFirst().orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult undo(int x, int y, int z, DataTransactionResult result) {
        return result.replacedData().stream().map(successful -> this.offer(x, y, z, successful)).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from) {
        return from.getValues().stream().map(value -> this.offer(xTo, yTo, zTo, value)).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from, MergeFunction function) {
        return from.getValues().stream().map(value -> {
            Value merged = this.get(xTo, yTo, zTo, value.key()).map(existing -> function.merge((Value)existing, value).asImmutable()).orElse((Value.Immutable)value);
            return this.offer(xTo, yTo, zTo, merged);
        }).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom, MergeFunction function) {
        return this.getValues(xFrom, yFrom, zFrom).stream().map(value -> {
            Value merged = this.get(xTo, yTo, zTo, value.key()).map(existing -> function.merge((Value)existing, value).asImmutable()).orElse(value.asImmutable());
            return this.offer(xTo, yTo, zTo, merged);
        }).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public boolean validateRawData(int x, int y, int z, DataView container) {
        return this.blockEntityArchetype(x, y, z).map(archetype -> archetype.validateRawData(container)).orElse(false);
    }

    @Override
    public void setRawData(int x, int y, int z, DataView container) throws InvalidDataException {
        this.blockEntityArchetype(x, y, z).ifPresent(archetype -> archetype.setRawData(container));
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        this.volume.addEntity(entry);
    }

    @Override
    public Biome biome(int x, int y, int z) {
        return this.volume.biome(x, y, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, Biome> biomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.biomeStream(min2, max, options);
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return this.volume.setBiome(x, y, z, biome);
    }

    @Override
    public ArchetypeVolume transform(Transformation transformation) {
        return new ReferentSchematicVolume(this, Objects.requireNonNull(transformation, "Transformation cannot be null"));
    }
}

