/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.CommandStorage;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldManager;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.accessor.world.level.storage.LevelStorageSource_LevelStorageAccessAccessor;
import org.spongepowered.common.accessor.world.level.storage.PrimaryLevelDataAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.levelgen.WorldGenSettingsBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.FutureUtil;
import org.spongepowered.common.world.server.SpongeWorldTemplate;

public abstract class SpongeWorldManager
implements WorldManager {
    private final MinecraftServer server;
    private final Path dimensionsDataPackDirectory;
    private final Path defaultWorldDirectory;
    private final Path customWorldsDirectory;
    private final Map<RegistryKey<World>, net.minecraft.world.server.ServerWorld> worlds;
    private static final TicketType<ResourceLocation> SPAWN_CHUNKS = TicketType.func_219484_a((String)"spawn_chunks", (i, o) -> i.compareTo(o));

    public SpongeWorldManager(MinecraftServer server) {
        this.server = server;
        this.dimensionsDataPackDirectory = ((MinecraftServerAccessor)server).accessor$storageSource().func_237285_a_(FolderName.field_237251_g_).resolve("plugin_dimension").resolve("data");
        try {
            Files.createDirectories(this.dimensionsDataPackDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.defaultWorldDirectory = ((LevelStorageSource_LevelStorageAccessAccessor)((MinecraftServerAccessor)this.server).accessor$storageSource()).accessor$levelPath();
        this.customWorldsDirectory = this.defaultWorldDirectory.resolve("dimensions");
        try {
            Files.createDirectories(this.customWorldsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.worlds = ((MinecraftServerAccessor)this.server).accessor$levels();
    }

    @Override
    public Server server() {
        return (Server)this.server;
    }

    public Path getDefaultWorldDirectory() {
        return this.defaultWorldDirectory;
    }

    public Path getDimensionDataPackDirectory() {
        return this.dimensionsDataPackDirectory;
    }

    @Override
    public ServerWorld defaultWorld() {
        net.minecraft.world.server.ServerWorld world = this.server.func_241755_D_();
        if (world == null) {
            throw new IllegalStateException("The default world has not been loaded yet! (Did you call this too early in the lifecycle?");
        }
        return (ServerWorld)world;
    }

    @Override
    public Optional<ServerWorld> world(ResourceKey key) {
        return Optional.ofNullable((ServerWorld)this.worlds.get(SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"))));
    }

    @Override
    public Optional<Path> worldDirectory(ResourceKey key) {
        Objects.requireNonNull(key, "key");
        Path directory = World.field_234918_g_.func_240901_a_().equals((Object)key) ? this.defaultWorldDirectory : (World.field_234919_h_.func_240901_a_().equals((Object)key) ? this.defaultWorldDirectory.resolve("DIM-1") : (World.field_234920_i_.func_240901_a_().equals((Object)key) ? this.defaultWorldDirectory.resolve("DIM1") : this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value())));
        if (Files.notExists(directory, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(directory);
    }

    @Override
    public Collection<ServerWorld> worlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    @Override
    public List<ResourceKey> worldKeys() {
        ArrayList<ResourceKey> worldKeys = new ArrayList<ResourceKey>();
        worldKeys.add((ResourceKey)World.field_234918_g_.func_240901_a_());
        if (Files.exists(this.defaultWorldDirectory.resolve(this.getDirectoryName((ResourceKey)World.field_234919_h_.func_240901_a_())), new LinkOption[0])) {
            worldKeys.add((ResourceKey)World.field_234919_h_.func_240901_a_());
        }
        if (Files.exists(this.defaultWorldDirectory.resolve(this.getDirectoryName((ResourceKey)World.field_234920_i_.func_240901_a_())), new LinkOption[0])) {
            worldKeys.add((ResourceKey)World.field_234920_i_.func_240901_a_());
        }
        try {
            for (Path namespacedDirectory : Files.walk(this.customWorldsDirectory, 1, new FileVisitOption[0]).collect(Collectors.toList())) {
                if (this.customWorldsDirectory.equals(namespacedDirectory)) continue;
                for (Path valueDirectory : Files.walk(namespacedDirectory, 1, new FileVisitOption[0]).collect(Collectors.toList())) {
                    if (namespacedDirectory.equals(valueDirectory)) continue;
                    worldKeys.add(ResourceKey.of(namespacedDirectory.getFileName().toString(), valueDirectory.getFileName().toString()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(worldKeys);
    }

    @Override
    public List<ResourceKey> templateKeys() {
        ArrayList<ResourceKey> templateKeys = new ArrayList<ResourceKey>();
        templateKeys.add(WorldTypes.OVERWORLD.location());
        templateKeys.add(WorldTypes.THE_NETHER.location());
        templateKeys.add(WorldTypes.THE_END.location());
        try (Stream<Path> pluginDirectories = Files.walk(this.getDimensionDataPackDirectory(), 1, new FileVisitOption[0]);){
            pluginDirectories.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(pluginDirectory -> {
                Path dimensionPath = pluginDirectory.resolve("dimension");
                if (Files.isDirectory(dimensionPath, new LinkOption[0])) {
                    try (Stream<Path> pluginTemplates = Files.walk(dimensionPath, 1, new FileVisitOption[0]);){
                        pluginTemplates.filter(template -> template.toString().endsWith(".json")).forEach(template -> templateKeys.add((ResourceKey)new ResourceLocation(pluginDirectory.getFileName().toString(), FilenameUtils.removeExtension((String)template.getFileName().toString()))));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return templateKeys;
    }

    @Override
    public boolean worldExists(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return true;
        }
        if (this.worlds.get(registryKey) != null) {
            return true;
        }
        boolean isVanillaSubLevel = World.field_234919_h_.equals(registryKey) || World.field_234920_i_.equals(registryKey);
        Path levelDirectory = isVanillaSubLevel ? this.defaultWorldDirectory.resolve(this.getDirectoryName(key)) : this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value());
        return Files.exists(levelDirectory, new LinkOption[0]);
    }

    @Override
    public Optional<ResourceKey> worldKey(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.worlds.values().stream().filter(w -> ((ServerWorld)w).uniqueId().equals(uniqueId)).map(w -> (ServerWorld)w).map(ServerWorld::key).findAny();
    }

    @Override
    public Collection<ServerWorld> worldsOfType(WorldType type) {
        Objects.requireNonNull(type, "type");
        return this.worlds().stream().filter(w -> w.worldType() == type).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(WorldTemplate template) {
        net.minecraft.world.server.ServerWorld serverWorld;
        ResourceKey key = Objects.requireNonNull(template, "template").key();
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        if (World.field_234918_g_.equals(registryKey)) {
            FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        if ((serverWorld = this.worlds.get(registryKey)) != null) {
            return CompletableFuture.completedFuture((ServerWorld)serverWorld);
        }
        this.saveTemplate(template);
        return this.loadWorld0(registryKey, ((SpongeWorldTemplate)template).asDimension(), (DimensionGeneratorSettings)template.generationConfig());
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(ResourceKey key) {
        net.minecraft.world.server.ServerWorld world;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        if ((world = this.worlds.get(registryKey)) != null) {
            return CompletableFuture.completedFuture((ServerWorld)world);
        }
        return this.loadTemplate(key).thenCompose(r -> {
            WorldTemplate loadedTemplate = r.orElse(null);
            if (loadedTemplate == null) {
                Dimension scratch = (Dimension)BootstrapProperties.worldGenSettings.func_236224_e_().func_230516_a_(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)((ResourceLocation)key)));
                if (scratch != null) {
                    ((ResourceKeyBridge)scratch).bridge$setKey(key);
                    loadedTemplate = new SpongeWorldTemplate(scratch);
                }
                if (loadedTemplate == null) {
                    return FutureUtil.completedWithException(new IOException(String.format("Failed to load a template for '%s'!", key)));
                }
                this.saveTemplate(loadedTemplate);
            }
            return this.loadWorld0(registryKey, ((SpongeWorldTemplate)loadedTemplate).asDimension(), (DimensionGeneratorSettings)loadedTemplate.generationConfig());
        });
    }

    private CompletableFuture<ServerWorld> loadWorld0(RegistryKey<World> registryKey, Dimension template, DimensionGeneratorSettings generatorSettings) {
        SaveFormat.LevelSave storageSource;
        ServerWorldInfo defaultLevelData = (ServerWorldInfo)this.server.func_240793_aU_();
        WorldSettings defaultLevelSettings = ((PrimaryLevelDataAccessor)defaultLevelData).accessor$settings();
        LevelStemBridge templateBridge = (LevelStemBridge)template;
        ResourceKey worldKey = ((ResourceKeyBridge)((Object)templateBridge)).bridge$getKey();
        WorldType worldType = (WorldType)template.func_236063_b_();
        Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)template.func_236063_b_());
        MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}' ({})", (Object)worldKey, (Object)worldTypeKey.map(Object::toString).orElse("inline"));
        String directoryName = this.getDirectoryName(worldKey);
        boolean isVanillaSubLevel = this.isVanillaSubWorld(directoryName);
        try {
            storageSource = isVanillaSubLevel ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(worldKey.namespace() + File.separator + worldKey.value());
        }
        catch (IOException e) {
            e.printStackTrace();
            return FutureUtil.completedWithException(new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e));
        }
        ServerWorldInfo levelData = (ServerWorldInfo)storageSource.func_237284_a_(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.func_234958_g_());
        if (levelData == null) {
            DimensionGeneratorSettings generationSettings;
            WorldSettings levelSettings;
            if (this.server.func_71242_L()) {
                levelSettings = MinecraftServer.field_213219_c;
                generationSettings = DimensionGeneratorSettings.func_242752_a((DynamicRegistries)BootstrapProperties.registries);
            } else {
                levelSettings = new WorldSettings(directoryName, (GameType)BootstrapProperties.gameMode.get(Sponge.game()), templateBridge.bridge$hardcore().orElse(BootstrapProperties.hardcore).booleanValue(), (Difficulty)BootstrapProperties.difficulty.get(Sponge.game()), templateBridge.bridge$commands().orElse(BootstrapProperties.commands).booleanValue(), new GameRules(), defaultLevelData.func_230403_C_());
                generationSettings = generatorSettings;
            }
            levelData = new ServerWorldInfo(levelSettings, generationSettings, Lifecycle.stable());
        }
        ((PrimaryLevelDataBridge)levelData).bridge$populateFromDimension(template);
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(worldTypeKey.orElse(null), worldKey);
        ((PrimaryLevelDataBridge)levelData).bridge$configAdapter(configAdapter);
        levelData.func_230412_a_(this.server.getServerModName(), this.server.func_230045_q_().isPresent());
        boolean isDebugGeneration = levelData.func_230418_z_().func_236227_h_();
        long seed = BiomeManager.func_235200_a_((long)levelData.func_230418_z_().func_236221_b_());
        IChunkStatusListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$progressListenerFactory().create(11);
        net.minecraft.world.server.ServerWorld world = new net.minecraft.world.server.ServerWorld(this.server, ((MinecraftServerAccessor)this.server).accessor$executor(), storageSource, (IServerWorldInfo)levelData, registryKey, (DimensionType)worldType, chunkStatusListener, template.func_236064_c_(), isDebugGeneration, seed, (List)ImmutableList.of(), true);
        this.worlds.put(registryKey, world);
        return ((CompletableFuture)((CompletableFuture)SpongeCommon.asyncScheduler().submit(() -> this.prepareWorld(world, isDebugGeneration)).thenApply(w -> {
            ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
            return w;
        })).thenCompose(w -> this.postWorldLoad((net.minecraft.world.server.ServerWorld)w, false))).thenApply(w -> (ServerWorld)w);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld world = this.worlds.get(registryKey);
        if (world == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.unloadWorld((ServerWorld)world);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ServerWorld world) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(world, "world").key());
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (world != this.worlds.get(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.unloadWorld0((net.minecraft.world.server.ServerWorld)world);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }, (Executor)SpongeCommon.server());
    }

    @Override
    public boolean templateExists(ResourceKey key) {
        return Files.exists(this.getDataPackFile(Objects.requireNonNull(key, "key")), new LinkOption[0]);
    }

    @Override
    public CompletableFuture<Optional<WorldTemplate>> loadTemplate(ResourceKey key) {
        Path dataPackFile = this.getDataPackFile(Objects.requireNonNull(key, "key"));
        if (Files.exists(dataPackFile, new LinkOption[0])) {
            try {
                Dimension template = this.loadTemplate0(SpongeWorldManager.createRegistryKey(key), dataPackFile);
                ((ResourceKeyBridge)template).bridge$setKey(key);
                return CompletableFuture.completedFuture(Optional.of(((LevelStemBridge)template).bridge$asTemplate()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Boolean> saveTemplate(WorldTemplate template) {
        Dimension scratch = ((SpongeWorldTemplate)Objects.requireNonNull(template, "template")).asDimension();
        try {
            JsonElement element = (JsonElement)SpongeWorldTemplate.DIRECT_CODEC.encodeStart((DynamicOps)WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)BootstrapProperties.registries), (Object)scratch).getOrThrow(true, s2 -> {});
            Path dataPackFile = this.getDataPackFile(template.key());
            Files.createDirectories(dataPackFile.getParent(), new FileAttribute[0]);
            DataPackSerializer.writeFile(dataPackFile, element);
            DataPackSerializer.writePackMetadata("World", this.dimensionsDataPackDirectory.getParent());
        }
        catch (Exception ex) {
            FutureUtil.completedWithException(ex);
        }
        return CompletableFuture.completedFuture(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Optional<ServerWorldProperties>> loadProperties(ResourceKey key) {
        IServerConfiguration levelData;
        SaveFormat.LevelSave storageSource;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        try {
            storageSource = isVanillaWorld ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(key.namespace() + File.separator + key.value());
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        try {
            ServerWorldInfo defaultLevelData = (ServerWorldInfo)this.server.func_240793_aU_();
            WorldSettings defaultLevelSettings = ((PrimaryLevelDataAccessor)defaultLevelData).accessor$settings();
            try {
                levelData = storageSource.func_237284_a_(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.func_234958_g_());
            }
            catch (Exception ex) {
                CompletableFuture<Optional<ServerWorldProperties>> completableFuture = FutureUtil.completedWithException(ex);
                try {
                    storageSource.close();
                }
                catch (IOException ex2) {
                    return FutureUtil.completedWithException(ex2);
                }
                return completableFuture;
            }
        }
        finally {
            try {
                storageSource.close();
            }
            catch (IOException ex) {
                return FutureUtil.completedWithException(ex);
            }
        }
        return this.loadTemplate(key).thenCompose(r -> {
            r.ifPresent(template -> {
                Dimension scratch = ((SpongeWorldTemplate)template).asDimension();
                ((PrimaryLevelDataBridge)levelData).bridge$populateFromDimension(scratch);
            });
            return CompletableFuture.completedFuture(Optional.of((ServerWorldProperties)levelData));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> saveProperties(ServerWorldProperties properties) {
        SaveFormat.LevelSave storageSource;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(properties, "properties").key());
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(false);
        }
        ResourceKey key = properties.key();
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        try {
            storageSource = isVanillaWorld ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(key.namespace() + File.separator + key.value());
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        try {
            try {
                storageSource.func_237288_a_(BootstrapProperties.registries, (IServerConfiguration)properties, null);
            }
            catch (Exception ex) {
                CompletableFuture<Boolean> completableFuture = FutureUtil.completedWithException(ex);
                try {
                    storageSource.close();
                }
                catch (IOException ex2) {
                    return FutureUtil.completedWithException(ex2);
                }
                return completableFuture;
            }
        }
        finally {
            try {
                storageSource.close();
            }
            catch (IOException ex) {
                return FutureUtil.completedWithException(ex);
            }
        }
        return this.loadTemplate(key).thenCompose(r -> {
            WorldTemplate template = r.orElse(null);
            if (template != null) {
                Dimension scratch = ((SpongeWorldTemplate)template).asDimension();
                ((LevelStemBridge)scratch).bridge$populateFromLevelData((ServerWorldInfo)properties);
                return this.saveTemplate(((LevelStemBridge)scratch).bridge$asTemplate());
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    @Override
    public CompletableFuture<Boolean> copyWorld(ResourceKey key, ResourceKey copyKey) {
        JsonObject fixedObject;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        RegistryKey<World> copyRegistryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(copyKey, "copyKey"));
        if (World.field_234918_g_.equals(copyRegistryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(copyKey)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld loadedWorld = this.worlds.get(registryKey);
        boolean disableLevelSaving = false;
        if (loadedWorld != null) {
            disableLevelSaving = loadedWorld.field_73058_d;
            loadedWorld.func_217445_a(null, true, loadedWorld.field_73058_d);
            loadedWorld.field_73058_d = true;
        }
        final boolean isDefaultWorld = this.isDefaultWorld(key);
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        final Path originalDirectory = isDefaultWorld ? this.defaultWorldDirectory : (isVanillaWorld ? this.defaultWorldDirectory.resolve(directoryName) : this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value()));
        boolean isVanillaCopyWorld = this.isVanillaWorld(copyKey);
        String copyDirectoryName = this.getDirectoryName(copyKey);
        final Path copyDirectory = isVanillaCopyWorld ? this.defaultWorldDirectory.resolve(copyDirectoryName) : this.customWorldsDirectory.resolve(copyKey.namespace()).resolve(copyKey.value());
        try {
            Files.walkFileTree(originalDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.getFileName().toString().equals("dimensions")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (isDefaultWorld && SpongeWorldManager.this.isVanillaSubWorld(dir.getFileName().toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Path relativize = originalDirectory.relativize(dir);
                    Path directory = copyDirectory.resolve(relativize);
                    Files.createDirectories(directory, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.equals("level_sponge.dat_old")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (fileName.equals(Constants.World.LEVEL_DAT_OLD)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.copy(file, copyDirectory.resolve(originalDirectory.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(copyDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FutureUtil.completedWithException(e);
        }
        if (loadedWorld != null) {
            loadedWorld.field_73058_d = disableLevelSaving;
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        Path copiedDimensionTemplate = this.getDataPackFile(copyKey);
        try {
            Files.createDirectories(copiedDimensionTemplate.getParent(), new FileAttribute[0]);
            Files.copy(dimensionTemplate, copiedDimensionTemplate, new CopyOption[0]);
        }
        catch (IOException e) {
            FutureUtil.completedWithException(e);
        }
        try (InputStream stream = Files.newInputStream(copiedDimensionTemplate, new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(stream);){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(reader);
            JsonObject root = element.getAsJsonObject();
            JsonObject spongeData = root.getAsJsonObject("#sponge");
            spongeData.remove("unique_id");
            fixedObject = root;
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        if (fixedObject != null) {
            try (BufferedWriter writer = Files.newBufferedWriter(copiedDimensionTemplate, new OpenOption[0]);){
                writer.write(fixedObject.toString());
            }
            catch (IOException e) {
                FutureUtil.completedWithException(e);
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> moveWorld(ResourceKey key, ResourceKey movedKey) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(movedKey)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        Path originalDirectory = isVanillaWorld ? this.defaultWorldDirectory.resolve(directoryName) : this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value());
        boolean isVanillaMoveWorld = this.isVanillaWorld(movedKey);
        String moveDirectoryName = this.getDirectoryName(movedKey);
        Path moveDirectory = isVanillaMoveWorld ? this.defaultWorldDirectory.resolve(moveDirectoryName) : this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value());
        try {
            Files.createDirectories(moveDirectory, new FileAttribute[0]);
            Files.move(originalDirectory, moveDirectory, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path configFile = SpongeCommon.spongeConfigDirectory().resolve(((Launch)Launch.instance()).id()).resolve("worlds").resolve(key.namespace()).resolve(key.value() + ".conf");
        Path copiedConfigFile = SpongeCommon.spongeConfigDirectory().resolve(((Launch)Launch.instance()).id()).resolve("worlds").resolve(movedKey.namespace()).resolve(movedKey.value() + ".conf");
        try {
            Files.createDirectories(copiedConfigFile.getParent(), new FileAttribute[0]);
            Files.move(configFile, copiedConfigFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        Path copiedDimensionTemplate = this.getDataPackFile(movedKey);
        try {
            Files.createDirectories(copiedDimensionTemplate.getParent(), new FileAttribute[0]);
            Files.move(dimensionTemplate, copiedDimensionTemplate, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> deleteWorld(ResourceKey key) {
        Path directory;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            boolean disableLevelSaving = loadedWorld.field_73058_d;
            loadedWorld.field_73058_d = true;
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                loadedWorld.field_73058_d = disableLevelSaving;
                return FutureUtil.completedWithException(e);
            }
        }
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        Path path = directory = isVanillaWorld ? this.defaultWorldDirectory.resolve(directoryName) : this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value());
        if (Files.exists(directory, new LinkOption[0])) {
            try {
                for (Path path2 : Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList())) {
                    Files.deleteIfExists(path2);
                }
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        Path configFile = SpongeCommon.spongeConfigDirectory().resolve(((Launch)Launch.instance()).id()).resolve("worlds").resolve(key.namespace()).resolve(key.value() + ".conf");
        try {
            Files.deleteIfExists(configFile);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        try {
            Files.deleteIfExists(dimensionTemplate);
        }
        catch (IOException e) {
            FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    private void unloadWorld0(net.minecraft.world.server.ServerWorld world) throws IOException {
        RegistryKey registryKey = world.func_234923_W_();
        if (world.func_217490_a(p -> true).size() != 0) {
            throw new IOException(String.format("World '%s' was told to unload but players remain.", registryKey.func_240901_a_()));
        }
        Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)world.func_230315_m_());
        SpongeCommon.logger().info("Unloading world '{}' ({})", (Object)registryKey.func_240901_a_(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
        UnloadWorldEvent unloadWorldEvent = SpongeEventFactory.createUnloadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)world);
        SpongeCommon.post(unloadWorldEvent);
        BlockPos spawnPoint = world.func_241135_u_();
        world.func_72863_F().func_217222_b(SPAWN_CHUNKS, new ChunkPos(spawnPoint), 11, (Object)registryKey.func_240901_a_());
        ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$configAdapter().save();
        ((ServerLevelBridge)world).bridge$setManualSave(true);
        try {
            world.func_217445_a(null, true, world.field_73058_d);
            world.close();
            ((ServerLevelBridge)world).bridge$getLevelSave().close();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        this.worlds.remove(registryKey);
    }

    public void loadLevel() {
        boolean multiworldEnabled;
        ServerWorldInfo defaultLevelData = (ServerWorldInfo)this.server.func_240793_aU_();
        DimensionGeneratorSettings defaultGenerationSettings = defaultLevelData.func_230418_z_();
        WorldSettings defaultLevelSettings = ((PrimaryLevelDataAccessor)defaultLevelData).accessor$settings();
        SimpleRegistry templates = defaultGenerationSettings.func_236224_e_();
        boolean bl = multiworldEnabled = this.server.func_71264_H() || this.server.func_71255_r();
        if (!multiworldEnabled) {
            SpongeCommon.logger().warn("The option 'allow-nether' has been set to 'false' in the server.properties. Multi-World support has been disabled and no worlds besides the default world will be loaded.");
        }
        for (RegistryEntry registryEntry : ((org.spongepowered.api.registry.Registry)templates).streamEntries().collect(Collectors.toList())) {
            boolean isDebugGeneration;
            ServerWorldInfo levelData;
            SaveFormat.LevelSave storageSource;
            ResourceKey worldKey = registryEntry.key();
            Dimension template = (Dimension)registryEntry.value();
            LevelStemBridge templateBridge = (LevelStemBridge)template;
            ((ResourceKeyBridge)((Object)templateBridge)).bridge$setKey(worldKey);
            boolean isDefaultWorld = this.isDefaultWorld(worldKey);
            if (!isDefaultWorld && !multiworldEnabled) continue;
            WorldType worldType = (WorldType)template.func_236063_b_();
            Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)template.func_236063_b_());
            MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}' ({})", (Object)worldKey, (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            if (!isDefaultWorld && !templateBridge.bridge$loadOnStartup()) {
                SpongeCommon.logger().warn("World '{}' has been disabled from loading at startup. Skipping...", (Object)worldKey);
                continue;
            }
            String directoryName = this.getDirectoryName(worldKey);
            boolean isVanillaSubLevel = this.isVanillaSubWorld(directoryName);
            if (isDefaultWorld) {
                storageSource = ((MinecraftServerAccessor)this.server).accessor$storageSource();
            } else {
                try {
                    storageSource = isVanillaSubLevel ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(worldKey.namespace() + File.separator + worldKey.value());
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e);
                }
            }
            if (isDefaultWorld) {
                levelData = defaultLevelData;
                isDebugGeneration = defaultGenerationSettings.func_236227_h_();
            } else {
                levelData = (ServerWorldInfo)storageSource.func_237284_a_(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.func_234958_g_());
                if (levelData == null) {
                    DimensionGeneratorSettings generationSettings;
                    WorldSettings levelSettings;
                    if (this.server.func_71242_L()) {
                        levelSettings = MinecraftServer.field_213219_c;
                        generationSettings = DimensionGeneratorSettings.func_242752_a((DynamicRegistries)BootstrapProperties.registries);
                    } else {
                        levelSettings = new WorldSettings(directoryName, (GameType)BootstrapProperties.gameMode.get(Sponge.game()), templateBridge.bridge$hardcore().orElse(BootstrapProperties.hardcore).booleanValue(), (Difficulty)BootstrapProperties.difficulty.get(Sponge.game()), templateBridge.bridge$commands().orElse(BootstrapProperties.commands).booleanValue(), new GameRules(), defaultLevelData.func_230403_C_());
                        generationSettings = ((WorldGenSettingsBridge)defaultLevelData.func_230418_z_()).bridge$copy();
                    }
                    isDebugGeneration = generationSettings.func_236227_h_();
                    ((DimensionGeneratorSettingsAccessor)generationSettings).accessor$dimensions((SimpleRegistry<Dimension>)new SimpleRegistry(Registry.field_239700_af_, Lifecycle.stable()));
                    levelData = new ServerWorldInfo(levelSettings, generationSettings, Lifecycle.stable());
                } else {
                    isDebugGeneration = levelData.func_230418_z_().func_236227_h_();
                }
            }
            ((PrimaryLevelDataBridge)levelData).bridge$populateFromDimension(template);
            InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(worldTypeKey.orElse(null), worldKey);
            ((PrimaryLevelDataBridge)levelData).bridge$configAdapter(configAdapter);
            levelData.func_230412_a_(this.server.getServerModName(), this.server.func_230045_q_().isPresent());
            long seed = BiomeManager.func_235200_a_((long)levelData.func_230418_z_().func_236221_b_());
            RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(worldKey);
            IChunkStatusListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$progressListenerFactory().create(11);
            ImmutableList spawners = isDefaultWorld ? ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((IServerWorldInfo)levelData)) : ImmutableList.of();
            net.minecraft.world.server.ServerWorld world = new net.minecraft.world.server.ServerWorld(this.server, ((MinecraftServerAccessor)this.server).accessor$executor(), storageSource, (IServerWorldInfo)levelData, registryKey, (DimensionType)worldType, chunkStatusListener, template.func_236064_c_(), isDebugGeneration, seed, (List)spawners, true);
            world.func_175723_af().func_235926_a_(levelData.func_230398_q_());
            this.worlds.put(registryKey, world);
            this.prepareWorld(world, isDebugGeneration);
        }
        ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
        for (Map.Entry entry : this.worlds.entrySet()) {
            try {
                this.postWorldLoad((net.minecraft.world.server.ServerWorld)entry.getValue(), true).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        ((SpongeUserManager)Sponge.server().userManager()).init();
        ((SpongeServer)SpongeCommon.server()).getPlayerDataManager().load();
    }

    private net.minecraft.world.server.ServerWorld prepareWorld(net.minecraft.world.server.ServerWorld world, boolean isDebugGeneration) {
        boolean isDefaultWorld = World.field_234918_g_.equals(world.func_234923_W_());
        ServerWorldInfo levelData = (ServerWorldInfo)world.func_72912_H();
        if (isDefaultWorld) {
            ((MinecraftServerAccessor)this.server).accessor$readScoreboard(world.func_217481_x());
            ((MinecraftServerAccessor)this.server).accessor$commandStorage(new CommandStorage(world.func_217481_x()));
        }
        boolean isInitialized = levelData.func_76070_v();
        LoadWorldEvent loadWorldEvent = SpongeEventFactory.createLoadWorldEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)world, isInitialized);
        SpongeCommon.post(loadWorldEvent);
        PlatformHooks.INSTANCE.getWorldHooks().postLoadWorld(world);
        ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$viewDistance().ifPresent(v -> ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$setViewDistance((Integer)v));
        world.func_175723_af().func_235926_a_(levelData.func_230398_q_());
        if (!isInitialized) {
            try {
                boolean hasSpawnAlready = ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$customSpawnPosition();
                if (!hasSpawnAlready) {
                    if (isDefaultWorld || ((ServerWorldProperties)world.func_72912_H()).performsSpawnLogic()) {
                        MinecraftServerAccessor.invoker$setInitialSpawn(world, (IServerWorldInfo)levelData, levelData.func_230418_z_().func_236223_d_(), isDebugGeneration, !isDebugGeneration);
                    } else if (World.field_234920_i_.equals(world.func_234923_W_())) {
                        ((ServerWorldInfo)world.func_72912_H()).func_176143_a(net.minecraft.world.server.ServerWorld.field_241108_a_, 0.0f);
                    }
                } else {
                    Features.field_243795_U.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), world.field_73012_v, new BlockPos(levelData.func_76079_c(), levelData.func_76075_d(), levelData.func_76074_e()));
                }
                levelData.func_76091_d(true);
                if (isDebugGeneration) {
                    ((MinecraftServerAccessor)this.server).invoker$setupDebugLevel((IServerConfiguration)levelData);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)("Exception initializing world '" + world.func_234923_W_().func_240901_a_() + "'"));
                try {
                    world.func_72914_a(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            levelData.func_76091_d(true);
        }
        this.server.func_184103_al().func_212504_a(world);
        if (levelData.func_230404_D_() != null) {
            ((ServerLevelBridge)world).bridge$getBossBarManager().func_201381_a(levelData.func_230404_D_());
        }
        return world;
    }

    private CompletableFuture<net.minecraft.world.server.ServerWorld> postWorldLoad(net.minecraft.world.server.ServerWorld world, boolean blocking) {
        ServerWorldInfo levelData = (ServerWorldInfo)world.func_72912_H();
        PrimaryLevelDataBridge levelBridge = (PrimaryLevelDataBridge)levelData;
        boolean isDefaultWorld = this.isDefaultWorld((ResourceKey)world.func_234923_W_().func_240901_a_());
        if (isDefaultWorld || levelBridge.bridge$performsSpawnLogic()) {
            Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)world.func_230315_m_());
            MinecraftServerAccessor.accessor$LOGGER().info("Preparing start region for world '{}' ({})", (Object)world.func_234923_W_().func_240901_a_(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            if (blocking) {
                this.loadSpawnChunks(world);
                return CompletableFuture.completedFuture(world);
            }
            return this.loadSpawnChunksAsync(world);
        }
        return CompletableFuture.completedFuture(world);
    }

    private CompletableFuture<net.minecraft.world.server.ServerWorld> loadSpawnChunksAsync(net.minecraft.world.server.ServerWorld world) {
        BlockPos spawnPoint = world.func_241135_u_();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        ServerChunkProvider serverChunkProvider = world.func_72863_F();
        serverChunkProvider.func_212863_j_().func_215598_a(500);
        int borderRadius = 11;
        int diameter = 21;
        int spawnChunks = 441;
        serverChunkProvider.func_217228_a(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
        CompletableFuture generationFuture = new CompletableFuture();
        Sponge.asyncScheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(task -> {
            if (serverChunkProvider.func_217229_b() >= 441) {
                Sponge.server().scheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(() -> generationFuture.complete(world)).build());
                task.cancel();
                Optional<ResourceKey> worldTypeKey = RegistryTypes.WORLD_TYPE.get().findValueKey((WorldType)world.func_230315_m_());
                MinecraftServerAccessor.accessor$LOGGER().info("Done preparing start region for world '{}' ({})", (Object)world.func_234923_W_().func_240901_a_(), (Object)worldTypeKey.map(Object::toString).orElse("inline"));
            }
        }).interval(10L, TimeUnit.MILLISECONDS).build());
        return generationFuture.thenApply(v -> {
            this.updateForcedChunks(world, serverChunkProvider);
            serverChunkProvider.func_212863_j_().func_215598_a(5);
            if (!((PrimaryLevelDataBridge)world.func_72912_H()).bridge$performsSpawnLogic()) {
                serverChunkProvider.func_217222_b(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
            }
            return world;
        });
    }

    private void loadSpawnChunks(net.minecraft.world.server.ServerWorld world) {
        BlockPos spawnPoint = world.func_241135_u_();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        IChunkStatusListener chunkStatusListener = ((ServerLevelBridge)world).bridge$getChunkStatusListener();
        chunkStatusListener.func_219509_a(chunkPos);
        ServerChunkProvider serverChunkProvider = world.func_72863_F();
        serverChunkProvider.func_212863_j_().func_215598_a(500);
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.func_211177_b());
        serverChunkProvider.func_217228_a(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
        while (serverChunkProvider.func_217229_b() != 441) {
            ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.func_211177_b() + 10L);
            ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        }
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.func_211177_b() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        this.updateForcedChunks(world, serverChunkProvider);
        ((MinecraftServerAccessor)this.server).accessor$nextTickTime(Util.func_211177_b() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        chunkStatusListener.func_219510_b();
        serverChunkProvider.func_212863_j_().func_215598_a(5);
        if (!((PrimaryLevelDataBridge)world.func_72912_H()).bridge$performsSpawnLogic()) {
            serverChunkProvider.func_217222_b(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
        }
    }

    private void updateForcedChunks(net.minecraft.world.server.ServerWorld world, ServerChunkProvider serverChunkProvider) {
        ForcedChunksSaveData forcedChunksSaveData = (ForcedChunksSaveData)world.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        if (forcedChunksSaveData != null) {
            LongIterator longIterator = forcedChunksSaveData.func_212438_a().iterator();
            while (longIterator.hasNext()) {
                long i = longIterator.nextLong();
                ChunkPos forceChunkPos = new ChunkPos(i);
                serverChunkProvider.func_217206_a(forceChunkPos, true);
            }
        }
    }

    private Dimension loadTemplate0(RegistryKey<World> registryKey, Path file) throws IOException {
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            Dimension dimension;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(reader);
                SingleTemplateAccess singleTemplateAccess = new SingleTemplateAccess(registryKey, element);
                WorldSettingsImport settingsAdapter = WorldSettingsImport.func_244336_a((DynamicOps)JsonOps.INSTANCE, (WorldSettingsImport.IResourceAccess)singleTemplateAccess, (DynamicRegistries.Impl)((DynamicRegistries.Impl)BootstrapProperties.registries));
                SimpleRegistry registry = new SimpleRegistry(Registry.field_239700_af_, Lifecycle.stable());
                settingsAdapter.func_241797_a_(registry, Registry.field_239700_af_, Dimension.field_236052_a_);
                Dimension template = registry.func_201756_e().findAny().orElse(null);
                if (template != null) {
                    ((LevelStemBridge)template).bridge$setFromSettings(false);
                }
                dimension = template;
            }
            return dimension;
        }
    }

    public static RegistryKey<World> createRegistryKey(ResourceKey key) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)key));
    }

    String getDirectoryName(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        if (World.field_234918_g_.equals(registryKey)) {
            return "";
        }
        if (World.field_234919_h_.equals(registryKey)) {
            return "DIM-1";
        }
        if (World.field_234920_i_.equals(registryKey)) {
            return "DIM1";
        }
        return key.value();
    }

    boolean isVanillaWorld(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        return World.field_234918_g_.equals(registryKey) || World.field_234919_h_.equals(registryKey) || World.field_234920_i_.equals(registryKey);
    }

    boolean isVanillaSubWorld(String directoryName) {
        return "DIM-1".equals(directoryName) || "DIM1".equals(directoryName);
    }

    boolean isDefaultWorld(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        return World.field_234918_g_.equals(registryKey);
    }

    Path getDataPackFile(ResourceKey key) {
        return this.getDimensionDataPackDirectory().resolve(key.namespace()).resolve("dimension").resolve(key.value() + ".json");
    }

    private static final class SingleTemplateAccess
    implements WorldSettingsImport.IResourceAccess {
        private final RegistryKey<?> key;
        private final JsonElement element;

        public SingleTemplateAccess(RegistryKey<?> key, JsonElement element) {
            this.key = key;
            this.element = element;
        }

        public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> registryKey) {
            if (this.key.func_244356_a(registryKey)) {
                return Collections.singletonList(new ResourceLocation(this.key.func_240901_a_().func_110624_b(), registryKey.func_240901_a_().func_110623_a() + "/" + this.key.func_240901_a_().func_110623_a() + ".json"));
            }
            return Collections.emptyList();
        }

        public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> ops, RegistryKey<? extends Registry<E>> registryKey, RegistryKey<E> elementKey, Decoder<E> decoder) {
            DataResult result = decoder.parse(ops, (Object)this.element);
            return result.map(t2 -> Pair.of((Object)t2, (Object)OptionalInt.empty()));
        }
    }
}

