/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.world.DimensionType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.api.world.WorldTypeEffects;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.api.world.biome.BiomeSampler;
import org.spongepowered.api.world.biome.BiomeSamplers;
import org.spongepowered.common.AbstractResourceKeyed;
import org.spongepowered.common.accessor.world.level.dimension.DimensionTypeAccessor;
import org.spongepowered.common.bridge.world.level.dimension.DimensionTypeBridge;
import org.spongepowered.common.data.fixer.SpongeDataCodec;
import org.spongepowered.common.registry.provider.DimensionEffectProvider;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeMinecraftDayTime;

public final class SpongeWorldTypeTemplate
extends AbstractResourceKeyed
implements WorldTypeTemplate {
    public final WorldTypeEffect effect;
    public final BiomeSampler biomeSampler;
    public final @Nullable MinecraftDayTime fixedTime;
    public final ResourceKey infiniburn;
    public final boolean ultraWarm;
    public final boolean natural;
    public final boolean skylight;
    public final boolean ceiling;
    public final boolean piglinSafe;
    public final boolean bedWorks;
    public final boolean respawnAnchorWorks;
    public final boolean hasRaids;
    public final boolean createDragonFight;
    public final float ambientLight;
    public final int logicalHeight;
    public final double coordinateScale;
    private static final Codec<SpongeDataSection> SPONGE_CODEC = RecordCodecBuilder.create(r -> r.group((App)ResourceLocation.field_240908_a_.optionalFieldOf("biome_sampler", (Object)new ResourceLocation("sponge", "column_fuzzed")).forGetter(v -> v.biomeSampler), (App)Codec.BOOL.optionalFieldOf("create_dragon_fight", (Object)Boolean.FALSE).forGetter(v -> v.createDragonFight)).apply((Applicative)r, r.stable(SpongeDataSection::new)));
    public static final Codec<DimensionType> DIRECT_CODEC = new MapCodec.MapCodecCodec(new SpongeDataCodec<DimensionType, SpongeDataSection>(DimensionType.field_235997_a_, SPONGE_CODEC, (type, data) -> ((DimensionTypeBridge)type).bridge$decorateData((SpongeDataSection)data), type -> ((DimensionTypeBridge)type).bridge$createData()));
    public static final Codec<Supplier<DimensionType>> CODEC = RegistryKeyCodec.func_241794_a_((RegistryKey)Registry.field_239698_ad_, DIRECT_CODEC);

    protected SpongeWorldTypeTemplate(BuilderImpl builder) {
        super(builder.key);
        this.effect = builder.effect;
        this.fixedTime = builder.fixedTime;
        this.infiniburn = builder.infiniburn;
        this.ultraWarm = builder.scorching;
        this.natural = builder.natural;
        this.skylight = builder.skylight;
        this.ceiling = builder.ceiling;
        this.piglinSafe = builder.piglinSafe;
        this.bedWorks = builder.bedsUsable;
        this.respawnAnchorWorks = builder.respawnAnchorsUsable;
        this.hasRaids = builder.hasRaids;
        this.ambientLight = builder.ambientLighting;
        this.logicalHeight = builder.logicalHeight;
        this.coordinateScale = builder.coordinateMultiplier;
        this.biomeSampler = builder.biomeSampler;
        this.createDragonFight = builder.createDragonFight;
    }

    public SpongeWorldTypeTemplate(ResourceKey key, DimensionType dimensionType) {
        super(key);
        OptionalLong fixedTime = ((DimensionTypeAccessor)dimensionType).accessor$fixedTime();
        this.fixedTime = fixedTime.isPresent() ? new SpongeMinecraftDayTime(fixedTime.getAsLong()) : null;
        this.skylight = dimensionType.func_218272_d();
        this.ceiling = dimensionType.func_236037_d_();
        this.ultraWarm = dimensionType.func_236040_e_();
        this.natural = dimensionType.func_236043_f_();
        this.coordinateScale = dimensionType.func_242724_f();
        this.piglinSafe = dimensionType.func_241509_i_();
        this.bedWorks = dimensionType.func_241510_j_();
        this.respawnAnchorWorks = dimensionType.func_241511_k_();
        this.hasRaids = dimensionType.func_241512_l_();
        this.logicalHeight = dimensionType.func_241513_m_();
        this.biomeSampler = (BiomeSampler)dimensionType.func_227176_e_();
        this.infiniburn = (ResourceKey)((DimensionTypeAccessor)dimensionType).accessor$infiniburn();
        this.effect = DimensionEffectProvider.INSTANCE.get((ResourceKey)((DimensionTypeAccessor)dimensionType).accessor$effectsLocation());
        this.ambientLight = ((DimensionTypeAccessor)dimensionType).accessor$ambientLight();
        this.createDragonFight = dimensionType.func_236046_h_();
    }

    @Override
    public DataPackType<WorldTypeTemplate> type() {
        return DataPackTypes.WORLD_TYPE;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        throw new MissingImplementationException("SpongeWorldTypeTemplate", "toContainer");
    }

    @Override
    public WorldTypeEffect effect() {
        return this.effect;
    }

    @Override
    public BiomeSampler biomeSampler() {
        return this.biomeSampler;
    }

    @Override
    public boolean scorching() {
        return this.ultraWarm;
    }

    @Override
    public boolean natural() {
        return this.natural;
    }

    @Override
    public double coordinateMultiplier() {
        return this.coordinateScale;
    }

    @Override
    public boolean hasSkylight() {
        return this.skylight;
    }

    @Override
    public boolean hasCeiling() {
        return this.ceiling;
    }

    @Override
    public float ambientLighting() {
        return this.ambientLight;
    }

    @Override
    public Optional<MinecraftDayTime> fixedTime() {
        return Optional.ofNullable(this.fixedTime);
    }

    @Override
    public boolean piglinSafe() {
        return this.piglinSafe;
    }

    @Override
    public boolean bedsUsable() {
        return this.bedWorks;
    }

    @Override
    public boolean respawnAnchorsUsable() {
        return this.respawnAnchorWorks;
    }

    @Override
    public boolean hasRaids() {
        return this.hasRaids;
    }

    @Override
    public int logicalHeight() {
        return this.logicalHeight;
    }

    @Override
    public boolean createDragonFight() {
        return this.createDragonFight;
    }

    public static final class FactoryImpl
    implements WorldTypeTemplate.Factory {
        @Override
        public WorldTypeTemplate overworld() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("overworld"), DimensionTypeAccessor.accessor$DEFAULT_OVERWORLD());
        }

        @Override
        public WorldTypeTemplate overworldCaves() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("overworld_caves"), DimensionTypeAccessor.accessor$DEFAULT_OVERWORLD_CAVES());
        }

        @Override
        public WorldTypeTemplate theNether() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("the_nether"), DimensionTypeAccessor.accessor$DEFAULT_NETHER());
        }

        @Override
        public WorldTypeTemplate theEnd() {
            return new SpongeWorldTypeTemplate(ResourceKey.minecraft("the_end"), DimensionTypeAccessor.accessor$DEFAULT_END());
        }
    }

    public static final class BuilderImpl
    extends AbstractResourceKeyedBuilder<WorldTypeTemplate, WorldTypeTemplate.Builder>
    implements WorldTypeTemplate.Builder {
        protected @Nullable WorldTypeEffect effect;
        protected @Nullable MinecraftDayTime fixedTime;
        protected @Nullable BiomeSampler biomeSampler;
        protected @Nullable ResourceKey infiniburn;
        protected boolean scorching;
        protected boolean natural;
        protected boolean skylight;
        protected boolean ceiling;
        protected boolean piglinSafe;
        protected boolean bedsUsable;
        protected boolean respawnAnchorsUsable;
        protected boolean hasRaids;
        protected boolean createDragonFight;
        protected float ambientLighting;
        protected int logicalHeight;
        protected double coordinateMultiplier;

        @Override
        public WorldTypeTemplate.Builder effect(WorldTypeEffect effect) {
            this.effect = Objects.requireNonNull(effect, "effect");
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder biomeSampler(BiomeSampler biomeSampler) {
            this.biomeSampler = Objects.requireNonNull(biomeSampler, "biomeFinder");
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder scorching(boolean scorching) {
            this.scorching = scorching;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder natural(boolean natural) {
            this.natural = natural;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder coordinateMultiplier(double coordinateMultiplier) {
            this.coordinateMultiplier = coordinateMultiplier;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder hasSkylight(boolean skylight) {
            this.skylight = skylight;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder hasCeiling(boolean ceiling) {
            this.ceiling = ceiling;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder ambientLighting(float ambientLighting) {
            this.ambientLighting = ambientLighting;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder fixedTime(@Nullable MinecraftDayTime fixedTime) {
            this.fixedTime = fixedTime;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder piglinSafe(boolean piglinSafe) {
            this.piglinSafe = piglinSafe;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder bedsUsable(boolean bedsUsable) {
            this.bedsUsable = bedsUsable;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder respawnAnchorsUsable(boolean respawnAnchorsUsable) {
            this.respawnAnchorsUsable = respawnAnchorsUsable;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder hasRaids(boolean hasRaids) {
            this.hasRaids = hasRaids;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder logicalHeight(int logicalHeight) {
            this.logicalHeight = logicalHeight;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder createDragonFight(boolean spawnDragonFight) {
            this.createDragonFight = spawnDragonFight;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder reset() {
            super.reset();
            this.effect = WorldTypeEffects.OVERWORLD;
            this.fixedTime = null;
            this.biomeSampler = BiomeSamplers.COLUMN_FUZZED;
            this.infiniburn = (ResourceKey)BlockTags.field_241277_aC_.func_230234_a_();
            this.scorching = false;
            this.natural = true;
            this.skylight = true;
            this.ceiling = false;
            this.piglinSafe = false;
            this.bedsUsable = true;
            this.respawnAnchorsUsable = false;
            this.hasRaids = true;
            this.ambientLighting = 0.5f;
            this.logicalHeight = 256;
            this.coordinateMultiplier = 1.0;
            this.createDragonFight = false;
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder from(WorldTypeTemplate value) {
            Objects.requireNonNull(value, "value");
            this.effect = value.effect();
            this.biomeSampler = value.biomeSampler();
            this.fixedTime = value.fixedTime().orElse(null);
            this.infiniburn = (ResourceKey)BlockTags.field_241277_aC_.func_230234_a_();
            this.scorching = value.scorching();
            this.natural = value.natural();
            this.skylight = value.hasSkylight();
            this.ceiling = value.hasCeiling();
            this.piglinSafe = value.piglinSafe();
            this.bedsUsable = value.bedsUsable();
            this.respawnAnchorsUsable = value.respawnAnchorsUsable();
            this.hasRaids = value.hasRaids();
            this.ambientLighting = value.ambientLighting();
            this.logicalHeight = value.logicalHeight();
            this.coordinateMultiplier = value.coordinateMultiplier();
            this.createDragonFight = value.createDragonFight();
            return this;
        }

        @Override
        public @NonNull WorldTypeTemplate build0() {
            return new SpongeWorldTypeTemplate(this);
        }
    }

    public static final class SpongeDataSection {
        public final ResourceLocation biomeSampler;
        public final boolean createDragonFight;

        public SpongeDataSection(ResourceLocation biomeSampler, boolean createDragonFight) {
            this.biomeSampler = biomeSampler;
            this.createDragonFight = createDragonFight;
        }
    }
}

