/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.accessor.world.level.block.entity.BlockEntityAccessor;
import org.spongepowered.common.accessor.world.level.chunk.ChunkBiomeContainerAccessor;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.ChunkCursor;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class VolumeStreamUtils {
    private VolumeStreamUtils() {
    }

    public static <T> Supplier<T> createWeaklyReferencedSupplier(T object, String name) {
        WeakReference weakReference = new WeakReference(object);
        return () -> {
            @Nullable T weaklyReferenced = weakReference.get();
            return Objects.requireNonNull(weaklyReferenced, () -> String.format("%s de-referenced!", name));
        };
    }

    public static <MC, T> Registry<T> nativeToSpongeRegistry(net.minecraft.util.registry.Registry<MC> registry) {
        return (Registry)registry;
    }

    public static Predicate<Tuple<Vector3d, EntityArchetype>> entityArchetypePositionFilter(Vector3i min2, Vector3i max) {
        return VolumeStreamUtils.filterPositions(tuple -> ((Vector3d)tuple.first()).toInt(), min2, max);
    }

    public static Predicate<Map.Entry<Vector3i, BlockEntityArchetype>> blockEntityArchetypePositionFilter(Vector3i min2, Vector3i max) {
        return VolumeStreamUtils.filterPositions(Map.Entry::getKey, min2, max);
    }

    public static <T> Predicate<T> filterPositions(Function<T, Vector3i> pos, Vector3i min2, Vector3i max) {
        return entity -> {
            Vector3i apply = (Vector3i)pos.apply(entity);
            return apply.x() >= min2.x() && apply.x() <= max.x() && apply.y() >= min2.y() && apply.y() <= max.y() && apply.z() >= min2.z() && apply.z() <= max.z();
        };
    }

    public static <R extends Region<R>> BiFunction<R, ChunkPos, @Nullable IChunk> getChunkAccessorByStatus(IWorldReader worldReader, boolean shouldGenerate) {
        Supplier<IWorldReader> readerSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(worldReader, "IWorldReader");
        return (world, chunkPos) -> {
            ChunkStatus chunkStatus = shouldGenerate ? ChunkStatus.field_222617_m : ChunkStatus.field_223226_a_;
            @Nullable IChunk ichunk = ((IWorldReader)readerSupplier.get()).func_217353_a(chunkPos.field_77276_a, chunkPos.field_77275_b, chunkStatus, shouldGenerate);
            if (shouldGenerate) {
                Objects.requireNonNull(ichunk, "Chunk was expected to load fully and generate, but somehow got a null chunk!");
            }
            if (ichunk instanceof ChunkPrimerWrapper) {
                return ((ChunkPrimerWrapper)ichunk).func_217336_u();
            }
            return ichunk;
        };
    }

    public static Function<IChunk, Stream<Map.Entry<BlockPos, net.minecraft.world.biome.Biome>>> getBiomesForChunkByPos(IWorldReader reader, Vector3i min2, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBiomeGetter().asTri(reader), min2, max);
    }

    public static Function<IChunk, Stream<Map.Entry<BlockPos, net.minecraft.block.BlockState>>> getBlockStatesForSections(Vector3i min2, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBlockStateGetter(), min2, max);
    }

    public static boolean setBiomeOnNativeChunk(int x, int y, int z, Biome biome, Supplier<@Nullable ChunkBiomeContainerAccessor> accessor, Runnable finalizer) {
        @Nullable ChunkBiomeContainerAccessor chunkBiomeContainerAccessor = accessor.get();
        if (chunkBiomeContainerAccessor == null) {
            return false;
        }
        int maskedX = x & BiomeContainer.field_227050_b_;
        int maskedY = MathHelper.func_76125_a((int)y, (int)0, (int)BiomeContainer.field_227051_c_);
        int maskedZ = z & BiomeContainer.field_227050_b_;
        int WIDTH_BITS = ChunkBiomeContainerAccessor.accessor$WIDTH_BITS();
        int posKey = maskedY << WIDTH_BITS + WIDTH_BITS | maskedZ << WIDTH_BITS | maskedX;
        net.minecraft.world.biome.Biome[] biomes = chunkBiomeContainerAccessor.accessor$biomes();
        biomes[posKey] = (net.minecraft.world.biome.Biome)biome;
        finalizer.run();
        return true;
    }

    public static void validateStreamArgs(Vector3i min2, Vector3i max, StreamOptions options) {
        Objects.requireNonNull(min2, "Minimum coordinates cannot be null");
        Objects.requireNonNull(max, "Maximum coordinates cannot be null");
        Objects.requireNonNull(options, "StreamOptions cannot be null!");
        if (min2.x() > max.x()) {
            throw new IllegalArgumentException("Min(x) must be greater than max(x)!");
        }
        if (min2.y() > max.y()) {
            throw new IllegalArgumentException("Min(y) must be greater than max y!");
        }
        if (min2.z() > max.z()) {
            throw new IllegalArgumentException("Min(z) must be greater than max z!");
        }
    }

    public static void validateStreamArgs(Vector3i min2, Vector3i max, Vector3i existingMin, Vector3i existingMax, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        if (existingMin.compareTo(Objects.requireNonNull(min2, "Minimum coordinates cannot be null!")) < 0) {
            throw new IllegalArgumentException(String.format("Minimum %s cannot be lower than the current minimum coordinates: %s", min2, existingMin));
        }
        if (existingMax.compareTo(Objects.requireNonNull(max, "Minimum coordinates cannot be null!")) < 0) {
            throw new IllegalArgumentException(String.format("Maximum %s cannot be greater than the current maximum coordinates: %s", max, existingMax));
        }
    }

    public static @NonNull Stream<Map.Entry<BlockPos, net.minecraft.entity.Entity>> getEntitiesFromChunk(Vector3i min2, Vector3i max, Chunk chunk) {
        return Arrays.stream(chunk.func_177429_s()).flatMap(Collection::stream).filter(entity -> VecHelper.inBounds(entity.func_233580_cy_(), min2, max)).filter(entity -> !(entity instanceof PlayerEntity)).map(entity -> new AbstractMap.SimpleEntry<BlockPos, net.minecraft.entity.Entity>(entity.func_233580_cy_(), (net.minecraft.entity.Entity)entity));
    }

    public static @NonNull BiConsumer<UUID, net.minecraft.entity.Entity> getOrCloneEntityWithVolume(boolean shouldCarbonCopy, @MonotonicNonNull ObjectArrayMutableEntityBuffer backingVolume, World level) {
        return shouldCarbonCopy ? (pos, entity) -> {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_70039_c(nbt);
            @Nullable net.minecraft.entity.Entity cloned = entity.func_200600_R().func_200721_a(level);
            Objects.requireNonNull(cloned, () -> String.format("EntityType[%s] creates a null Entity!", EntityType.func_200718_a((EntityType)entity.func_200600_R()))).func_70020_e(nbt);
            backingVolume.spawnEntity((Entity)cloned);
        } : (pos, tile) -> {};
    }

    public static @NonNull BiConsumer<BlockPos, TileEntity> getBlockEntityOrCloneToBackingVolume(boolean shouldCarbonCopy, ObjectArrayMutableBlockEntityBuffer backingVolume, @Nullable World level) {
        return shouldCarbonCopy ? (pos, tile) -> {
            CompoundNBT nbt = tile.func_189515_b(new CompoundNBT());
            @Nullable TileEntity cloned = tile.func_200662_C().func_200968_a();
            net.minecraft.block.BlockState state = tile.func_195044_w();
            Objects.requireNonNull(cloned, () -> String.format("TileEntityType[%s] creates a null TileEntity!", TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()))).func_230337_a_(state, nbt);
            if (level != null) {
                ((BlockEntityAccessor)cloned).accessor$level(level);
            }
            backingVolume.addBlockEntity(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (BlockEntity)cloned);
        } : (pos, tile) -> {};
    }

    public static BiConsumer<BlockPos, net.minecraft.block.BlockState> getOrCopyBlockState(boolean shouldCarbonCopy, ArrayMutableBlockBuffer backingVolume) {
        return (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((BlockPos)pos, (net.minecraft.block.BlockState)blockState);
            }
        };
    }

    public static <R extends Region<R>> BiFunction<BlockPos, R, net.minecraft.util.Tuple<BlockPos, net.minecraft.block.BlockState>> getBlockStateFromThisOrCopiedVolume(boolean shouldCarbonCopy, ArrayMutableBlockBuffer backingVolume) {
        return (blockPos, world) -> {
            net.minecraft.block.BlockState tileEntity = shouldCarbonCopy ? backingVolume.getBlock((BlockPos)blockPos) : ((IWorldReader)world).func_180495_p(blockPos);
            return new net.minecraft.util.Tuple(blockPos, (Object)tileEntity);
        };
    }

    public static Predicate<net.minecraft.entity.Entity> apiToImplPredicate(Predicate<? super Entity> filter) {
        return entity -> entity instanceof Entity && filter.test((Entity)entity);
    }

    public static boolean setBiome(IChunk chunk, int x, int y, int z, Biome biome) {
        boolean result = VolumeStreamUtils.setBiome(chunk.func_225549_i_(), x, y, z, biome);
        if (result) {
            chunk.func_177427_f(true);
        }
        return result;
    }

    public static boolean setBiome(@Nullable BiomeContainer biomeContainer, int x, int y, int z, Biome biome) {
        if (biomeContainer == null) {
            return false;
        }
        net.minecraft.world.biome.Biome[] biomes = ((ChunkBiomeContainerAccessor)biomeContainer).accessor$biomes();
        int maskedX = x & BiomeContainer.field_227050_b_;
        int maskedY = MathHelper.func_76125_a((int)y, (int)0, (int)BiomeContainer.field_227051_c_);
        int maskedZ = z & BiomeContainer.field_227050_b_;
        int WIDTH_BITS = ChunkBiomeContainerAccessor.accessor$WIDTH_BITS();
        int posKey = maskedY << WIDTH_BITS + WIDTH_BITS | maskedZ << WIDTH_BITS | maskedX;
        biomes[posKey] = (net.minecraft.world.biome.Biome)biome;
        return true;
    }

    private static QuadFunction<IChunk, ChunkSection, BlockPos, IWorldReader, net.minecraft.world.biome.Biome> chunkSectionBiomeGetter() {
        return (chunk, chunkSection, pos, world) -> {
            if (chunk.func_225549_i_() == null) {
                if (chunk instanceof Chunk) {
                    return ((Chunk)chunk).func_177412_p().func_225526_b_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return world.func_225604_a_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return chunk.func_225549_i_().func_225526_b_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        };
    }

    private static TriFunction<IChunk, ChunkSection, BlockPos, net.minecraft.block.BlockState> chunkSectionBlockStateGetter() {
        return (chunk, chunkSection, pos) -> chunkSection.func_177485_a(pos.func_177958_n() - (chunk.func_76632_l().field_77276_a << 4), pos.func_177956_o() & 0xF, pos.func_177952_p() - (chunk.func_76632_l().field_77275_b << 4));
    }

    private static <T> Function<IChunk, Stream<Map.Entry<BlockPos, T>>> getElementByPosition(TriFunction<IChunk, ChunkSection, BlockPos, T> elementAccessor, Vector3i min2, Vector3i max) {
        ChunkCursor minCursor = new ChunkCursor(min2);
        ChunkCursor maxCursor = new ChunkCursor(max);
        return chunk -> {
            ChunkPos pos = chunk.func_76632_l();
            int xStart = pos.field_77276_a == minCursor.chunkX ? minCursor.xOffset : 0;
            int xEnd = pos.field_77276_a == maxCursor.chunkX ? maxCursor.xOffset + 1 : 16;
            int zStart = pos.field_77275_b == minCursor.chunkZ ? minCursor.zOffset : 0;
            int zEnd = pos.field_77275_b == maxCursor.chunkZ ? maxCursor.zOffset + 1 : 16;
            int chunkMinX = pos.field_77276_a << 4;
            int chunkMinZ = pos.field_77275_b << 4;
            return Arrays.stream(chunk.func_76587_i()).filter(Objects::nonNull).filter(chunkSection -> chunkSection.func_222632_g() >= minCursor.ySection && chunkSection.func_222632_g() <= maxCursor.ySection).flatMap(chunkSection -> IntStream.range(zStart, zEnd).mapToObj(z -> IntStream.range(xStart, xEnd).mapToObj(x -> {
                int sectionY = chunkSection.func_222632_g();
                int yStart = sectionY == minCursor.ySection ? minCursor.yOffset : 0;
                int yEnd = sectionY == maxCursor.ySection ? maxCursor.yOffset + 1 : 16;
                return IntStream.range(yStart, yEnd).mapToObj(y -> {
                    int adjustedX = x + chunkMinX;
                    int adjustedY = y + sectionY;
                    int adjustedZ = z + chunkMinZ;
                    BlockPos blockPos = new BlockPos(adjustedX, adjustedY, adjustedZ);
                    Object apply = Objects.requireNonNull(elementAccessor.apply((IChunk)chunk, (ChunkSection)chunkSection, blockPos), "Element cannot be null");
                    return new AbstractMap.SimpleEntry(blockPos, apply);
                });
            })).flatMap(Function.identity()).flatMap(Function.identity()));
        };
    }

    public static <W extends Region<W>> VolumeStream<W, BlockState> generateBlockStream(IWorldReader reader, Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, (Region)reader, VolumeStreamUtils.getOrCopyBlockState(shouldCarbonCopy, backingVolume), VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBlockStatesForSections(min2, max), VolumeStreamUtils.getBlockStateFromThisOrCopiedVolume(shouldCarbonCopy, backingVolume));
    }

    public static <R extends Region<R>> VolumeStream<R, BlockEntity> getBlockEntityStream(IWorldReader reader, Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, (Region)reader, VolumeStreamUtils.getBlockEntityOrCloneToBackingVolume(shouldCarbonCopy, backingVolume, reader instanceof World ? (World)reader : null), VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, tileEntity) -> key, chunk -> chunk instanceof Chunk ? ((Chunk)chunk).func_177434_r().entrySet().stream().filter(entry -> VecHelper.inBounds((BlockPos)entry.getKey(), min2, max)) : Stream.empty(), (blockPos, world) -> {
            @Nullable TileEntity tileEntity = shouldCarbonCopy ? backingVolume.getTileEntity((BlockPos)blockPos) : ((IWorldReader)world).func_175625_s(blockPos);
            return new net.minecraft.util.Tuple(blockPos, (Object)tileEntity);
        });
    }

    public static <R extends Region<R>> VolumeStream<R, Biome> getBiomeStream(IWorldReader reader, Vector3i min2, Vector3i max, StreamOptions options) {
        ObjectArrayMutableBiomeBuffer backingVolume;
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        if (shouldCarbonCopy) {
            net.minecraft.util.registry.Registry biomeRegistry = reader instanceof World ? (net.minecraft.util.registry.Registry)((World)reader).func_241828_r().func_230521_a_(net.minecraft.util.registry.Registry.field_239720_u_).get() : WorldGenRegistries.field_243657_i;
            backingVolume = new ObjectArrayMutableBiomeBuffer(min2, size, VolumeStreamUtils.nativeToSpongeRegistry(biomeRegistry));
        } else {
            backingVolume = null;
        }
        return VolumeStreamUtils.generateStream(min2, max, options, (Region)reader, (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((BlockPos)pos, (net.minecraft.world.biome.Biome)biome);
            }
        }, VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBiomesForChunkByPos(reader, min2, max), (blockPos, world) -> {
            net.minecraft.world.biome.Biome biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()) : ((IWorldReader)world).func_226691_t_(blockPos);
            return new net.minecraft.util.Tuple(blockPos, (Object)biome);
        });
    }

    public static <R extends Volume, API, MC, Section, KeyReference> VolumeStream<R, API> generateStream(Vector3i min2, Vector3i max, StreamOptions options, R ref, BiConsumer<KeyReference, MC> identityFunction, BiFunction<R, ChunkPos, Section> chunkAccessor, BiFunction<BlockPos, MC, KeyReference> entityToKey, Function<Section, Stream<Map.Entry<BlockPos, MC>>> entityAccessor, BiFunction<KeyReference, R, net.minecraft.util.Tuple<BlockPos, MC>> filteredPositionEntityAccessor) {
        Supplier<R> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(ref, "World");
        BlockPos chunkMin = new BlockPos(min2.x() >> 4, 0, min2.z() >> 4);
        BlockPos chunkMax = new BlockPos(max.x() >> 4, 0, max.z() >> 4);
        Stream<Object> sectionStream = IntStream.range(chunkMin.func_177958_n(), chunkMax.func_177958_n() + 1).mapToObj(x -> IntStream.range(chunkMin.func_177952_p(), chunkMax.func_177952_p() + 1).mapToObj(z -> new ChunkPos(x, z))).flatMap(Function.identity()).map(pos -> chunkAccessor.apply(ref, (ChunkPos)pos));
        return VolumeStreamUtils.generateStreamInternal(options, identityFunction, entityToKey, entityAccessor, filteredPositionEntityAccessor, worldSupplier, sectionStream);
    }

    public static <R extends Volume, API, MC, Section, KeyReference> VolumeStream<R, API> generateStream(StreamOptions options, R ref, Section section, Function<Section, Stream<Map.Entry<BlockPos, MC>>> entityAccessor, BiConsumer<KeyReference, MC> identityFunction, BiFunction<BlockPos, MC, KeyReference> entityToKey, BiFunction<KeyReference, R, net.minecraft.util.Tuple<BlockPos, @Nullable MC>> filteredPositionEntityAccessor) {
        Supplier<R> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(ref, "World");
        Stream<Section> sectionStream = Stream.of(section);
        return VolumeStreamUtils.generateStreamInternal(options, identityFunction, entityToKey, entityAccessor, filteredPositionEntityAccessor, worldSupplier, sectionStream);
    }

    private static <R extends Volume, API, MC, Section, KeyReference> SpongeVolumeStream<R, API> generateStreamInternal(StreamOptions options, BiConsumer<KeyReference, MC> identityFunction, BiFunction<BlockPos, MC, KeyReference> entityToKey, Function<Section, Stream<Map.Entry<BlockPos, MC>>> entityAccessor, BiFunction<KeyReference, R, net.minecraft.util.Tuple<BlockPos, MC>> filteredPositionEntityAccessor, Supplier<R> worldSupplier, Stream<Section> sectionStream) {
        Stream<Object> filteredPosStream;
        Function<net.minecraft.util.Tuple, VolumeElement> elementGenerator = tuple -> {
            Supplier<Object> blockEntitySupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(tuple.func_76340_b(), "Element");
            Vector3d blockEntityPos = VecHelper.toVector3d((BlockPos)tuple.func_76341_a());
            return VolumeElement.of(worldSupplier, blockEntitySupplier, blockEntityPos);
        };
        BiConsumer<Map.Entry, Set> entryConsumer = (entry, poses) -> {
            BlockPos pos = (BlockPos)entry.getKey();
            Object keyRef = entityToKey.apply(pos, entry.getValue());
            poses.add(keyRef);
            identityFunction.accept(keyRef, entry.getValue());
        };
        if (options.loadingStyle().immediateLoading()) {
            LinkedHashSet availableTileEntityPositions = new LinkedHashSet();
            sectionStream.map(entityAccessor).forEach(map -> map.forEach(entry -> entryConsumer.accept((Map.Entry)entry, availableTileEntityPositions)));
            filteredPosStream = availableTileEntityPositions.stream();
        } else {
            filteredPosStream = sectionStream.flatMap(chunk -> {
                LinkedHashSet blockEntityPoses = new LinkedHashSet();
                ((Stream)entityAccessor.apply(chunk)).forEach(entry -> entryConsumer.accept((Map.Entry)entry, blockEntityPoses));
                return blockEntityPoses.stream();
            });
        }
        Stream volumeStreamBacker = filteredPosStream.map(pos -> (net.minecraft.util.Tuple)filteredPositionEntityAccessor.apply(pos, (Volume)worldSupplier.get())).filter(Objects::nonNull).filter(tuple -> Objects.nonNull(tuple.func_76340_b())).map(elementGenerator);
        return new SpongeVolumeStream(volumeStreamBacker, worldSupplier);
    }

    public static interface QuadFunction<A, B, C, D, Out> {
        public Out apply(A var1, B var2, C var3, D var4);

        default public TriFunction<A, B, C, Out> asTri(D d) {
            Supplier<D> dSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(d, "D");
            return (a, b, c) -> this.apply(a, b, c, dSupplier.get());
        }
    }

    public static interface TriFunction<A, B, C, Out> {
        public Out apply(A var1, B var2, C var3);
    }
}

