/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class ObjectArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements BiomeVolume.Modifiable<ObjectArrayMutableBiomeBuffer> {
    private final RegistryKey<Biome>[] biomes;
    private final Registry<Biome> registry;

    public ObjectArrayMutableBiomeBuffer(Vector3i start, Vector3i size, Registry<Biome> biomeRegistry) {
        super(start, size);
        this.biomes = new RegistryKey[size.x() * size.y() * size.z()];
        this.registry = biomeRegistry;
        Arrays.fill(this.biomes, Biomes.OCEAN);
    }

    @Override
    public Biome biome(int x, int y, int z) {
        this.checkRange(x, y, z);
        RegistryKey<Biome> key = this.biomes[this.getIndex(x, y, z)];
        return (Biome)this.registry.value(key);
    }

    public net.minecraft.world.biome.Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        RegistryKey<Biome> key = this.biomes[this.getIndex(x, y, z)];
        return (net.minecraft.world.biome.Biome)this.registry.value(key);
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        this.checkRange(x, y, z);
        return this.registry.findValueKey(biome).map(key -> {
            this.biomes[this.getIndex((int)x, (int)y, (int)z)] = RegistryKey.of(this.registry.type(), key);
            return true;
        }).orElse(false);
    }

    public boolean setBiome(BlockPos pos, net.minecraft.world.biome.Biome biome) {
        Objects.requireNonNull(biome, "biome");
        Objects.requireNonNull(pos, "pos");
        this.checkRange(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return this.registry.findValueKey((Biome)biome).map(key -> {
            this.biomes[this.getIndex((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p())] = RegistryKey.of(this.registry.type(), key);
            return true;
        }).orElse(false);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArrayMutableBiomeBuffer that = (ObjectArrayMutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<ObjectArrayMutableBiomeBuffer, Biome> biomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, this.min(), this.max(), options);
        RegistryKey[] buffer = options.carbonCopy() ? Arrays.copyOf(this.biomes, this.biomes.length) : this.biomes;
        Stream stateStream = IntStream.range(min2.x(), max.x() + 1).mapToObj(x -> IntStream.range(min2.z(), max.z() + 1).mapToObj(z -> IntStream.range(min2.y(), max.y() + 1).mapToObj(y -> VolumeElement.of(this, () -> {
            RegistryKey key = buffer[this.getIndex(x, y, z)];
            Biome biome = (Biome)this.registry.value(key);
            return biome;
        }, new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ObjectArrayMutableBiomeBuffer, Biome>(stateStream, () -> this);
    }
}

