/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.WorldPersistenceHooks;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Client;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.packet.SpongePacketHandler;
import org.spongepowered.forge.data.SpongeLevelDataPersistence;
import org.spongepowered.forge.hook.ForgeEntityHooks;
import org.spongepowered.forge.hook.ForgeEventHooks;
import org.spongepowered.forge.hook.ForgeWorldHooks;

@Mod(value="spongeforge")
public final class SpongeForge {
    private final Logger logger = LogManager.getLogger("spongeforge");

    public SpongeForge() {
        WorldPersistenceHooks.addHook((WorldPersistenceHooks.WorldPersistenceHook)SpongeLevelDataPersistence.INSTANCE);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::onCommonSetup);
        modBus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PlatformHooks.INSTANCE.setEventHooks(new ForgeEventHooks());
        PlatformHooks.INSTANCE.setEntityHooks(new ForgeEntityHooks());
        PlatformHooks.INSTANCE.setWorldHooks(new ForgeWorldHooks());
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.callConstructEvent();
        lifecycle.callRegisterFactoryEvent();
        lifecycle.callRegisterBuilderEvent();
        lifecycle.callRegisterChannelEvent();
        lifecycle.establishGameServices();
        lifecycle.establishDataKeyListeners();
        SpongePacketHandler.init((SpongeChannelManager)Sponge.channelManager());
        this.logger.info("SpongeForge v{} initialized", (Object)((Launch)Launch.instance()).platformPlugin().metadata().version());
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Client minecraft = (Client)event.getMinecraftSupplier().get();
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.establishGlobalRegistries();
        lifecycle.establishDataProviders();
        lifecycle.callRegisterDataEvent();
        lifecycle.establishClientRegistries(minecraft);
        lifecycle.callStartingEngineEvent(minecraft);
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        ConfigHandle.setSaveSuppressed(false);
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.establishServerServices();
        lifecycle.establishServerFeatures();
        lifecycle.establishServerRegistries((Server)event.getServer());
        lifecycle.callStartingEngineEvent((Server)event.getServer());
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.callStartedEngineEvent((Server)event.getServer());
    }

    @SubscribeEvent
    public void onServerStoppedEvent(FMLServerStoppedEvent event) {
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.callStoppingEngineEvent((Server)event.getServer());
    }
}

