/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.model.PluginDependency;

public final class PluginDependencyConfigurable
implements IConfigurable {
    private final PluginMetadata metadata;
    private final PluginDependency dependency;

    public PluginDependencyConfigurable(PluginMetadata metadata, PluginDependency dependency) {
        this.metadata = metadata;
        this.dependency = dependency;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        if (key.length != 1) {
            return Optional.empty();
        }
        String query = key[0];
        if ("modId".equals(query)) {
            return Optional.of(this.dependency.id());
        }
        if ("mandatory".equals(query)) {
            return Optional.of(!this.dependency.optional());
        }
        if ("versionRange".equals(query)) {
            return Optional.of(this.dependency.version().toString());
        }
        if ("ordering".equals(query)) {
            return Optional.of(this.loadToOrdering(this.dependency.loadOrder()).toString());
        }
        if ("side".equals(query)) {
            return Optional.of(IModInfo.DependencySide.BOTH.toString());
        }
        return Optional.empty();
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return Collections.emptyList();
    }

    private IModInfo.Ordering loadToOrdering(PluginDependency.LoadOrder order) {
        if (order == PluginDependency.LoadOrder.AFTER) {
            return IModInfo.Ordering.AFTER;
        }
        return IModInfo.Ordering.NONE;
    }
}

