/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.metadata;

import java.util.ArrayList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.StandardPluginMetadata;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginContributor;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginDependency;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginLinks;
import org.spongepowered.plugin.metadata.model.PluginDependency;

public final class PluginMetadataUtils {
    public static PluginMetadata modToPlugin(ModInfo info) {
        StandardPluginMetadata.Builder builder = StandardPluginMetadata.builder();
        ((StandardPluginMetadata.Builder)builder.id(info.getModId()).name(info.getDisplayName()).version(info.getVersion().toString())).description(info.getDescription()).entrypoint("unknown").addContributor(StandardPluginContributor.builder().name(info.getConfigElement(new String[]{"authors"}).orElse("unknown").toString()).build());
        builder.links(StandardPluginLinks.builder().issues(info.getOwningFile().getIssueURL()).build());
        ArrayList<StandardPluginDependency> dependencies = new ArrayList<StandardPluginDependency>();
        for (IModInfo.ModVersion dependency : info.getDependencies()) {
            StandardPluginDependency.Builder depBuilder = StandardPluginDependency.builder();
            depBuilder.id(dependency.getModId()).loadOrder(PluginMetadataUtils.orderingToLoad(dependency.getOrdering())).version(dependency.getVersionRange().toString());
            dependencies.add(depBuilder.build());
        }
        if (!dependencies.isEmpty()) {
            builder.dependencies(dependencies);
        }
        return (PluginMetadata)builder.build();
    }

    private static PluginDependency.LoadOrder orderingToLoad(IModInfo.Ordering ordering) {
        if (ordering == IModInfo.Ordering.AFTER) {
            return PluginDependency.LoadOrder.AFTER;
        }
        return PluginDependency.LoadOrder.UNDEFINED;
    }
}

