/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery;

import cpw.mods.gross.Java9ClassLoaderUtil;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.Launcher;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.forge.applaunch.loading.moddiscovery.LanguageLoaderModFileFactory;
import org.spongepowered.forge.applaunch.loading.moddiscovery.ModFileParsers;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.LibraryManager;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.LibraryModFileFactory;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.LibraryModFileInfoParser;
import org.spongepowered.forge.applaunch.plugin.ForgePluginPlatform;
import org.spongepowered.forge.applaunch.service.ForgeProductionBootstrap;

public final class ForgeBootstrap
extends AbstractJarFileLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Path INVALID_PATH = Paths.get("This", "Path", "Should", "Never", "Exist", "Because", "That", "Would", "Be", "Stupid", "CON", "AUX", "/dev/null");
    private static final String[] EXCLUDED_PATHS = new String[]{"org/spongepowered/common/applaunch/", "org/spongepowered/forge/applaunch/"};
    private LibraryManager libraryManager;
    private final Set<IModFile> dummyModFiles = ConcurrentHashMap.newKeySet();

    public List<IModFile> scanMods() {
        ArrayList<IModFile> jars = new ArrayList<IModFile>();
        try {
            ModFile spongeforge = ModFile.newFMLInstance((Path)Paths.get(ForgeBootstrap.class.getProtectionDomain().getCodeSource().getLocation().toURI()), (IModLocator)this);
            this.modJars.compute(spongeforge, (mf, fs) -> this.createFileSystem((IModFile)mf));
            jars.add((IModFile)spongeforge);
            ModFile spongeapi = this.newDummySpongeFile((IModFile)spongeforge, (IModLocator)this, "spongeapimod");
            jars.add((IModFile)spongeapi);
            this.dummyModFiles.add((IModFile)spongeapi);
            ModFile sponge = this.newDummySpongeFile((IModFile)spongeforge, (IModLocator)this, "spongemod");
            jars.add((IModFile)sponge);
            this.dummyModFiles.add((IModFile)sponge);
            IModFile spongeForgeAsLanguageProvider = LanguageLoaderModFileFactory.INSTANCE.build(Paths.get(ForgeBootstrap.class.getProtectionDomain().getCodeSource().getLocation().toURI()), (IModLocator)this, LibraryModFileInfoParser.INSTANCE);
            this.modJars.compute(spongeForgeAsLanguageProvider, (mf, fs) -> (FileSystem)this.modJars.get(spongeforge));
            jars.add(spongeForgeAsLanguageProvider);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (!FMLEnvironment.production) {
            for (URL url : Java9ClassLoaderUtil.getSystemClassPathURLs()) {
                try {
                    URI uri = url.toURI();
                    Path path = Paths.get(uri);
                    if (!this.isLibrary(path)) continue;
                    IModFile file = LibraryModFileFactory.INSTANCE.build(path, (IModLocator)this, LibraryModFileInfoParser.INSTANCE);
                    this.modJars.compute(file, (mf, fs) -> this.createFileSystem((IModFile)mf));
                    jars.add(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            try {
                this.libraryManager.validate();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to download and validate Sponge libraries", ex);
            }
            this.libraryManager.finishedProcessing();
            for (LibraryManager.Library library : this.libraryManager.getAll().values()) {
                Path path = library.getFile();
                LOGGER.debug("Adding jar {} to classpath as a library", (Object)path);
                IModFile file = LibraryModFileFactory.INSTANCE.build(path, (IModLocator)this, LibraryModFileInfoParser.INSTANCE);
                this.modJars.compute(file, (mf, fs) -> this.createFileSystem((IModFile)mf));
                jars.add(file);
            }
        }
        return jars;
    }

    public String name() {
        return "spongeforge";
    }

    public Path findPath(IModFile modFile, String ... path) {
        if (this.dummyModFiles.contains(modFile)) {
            return INVALID_PATH;
        }
        Path foundPath = super.findPath(modFile, path);
        if (this.isTCLExcluded(foundPath)) {
            return INVALID_PATH;
        }
        return foundPath;
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        if (this.dummyModFiles.contains(file)) {
            return;
        }
        super.scanFile(file, path -> {
            if (!this.isTCLExcluded((Path)path)) {
                pathConsumer.accept((Path)path);
            }
        });
    }

    public boolean isValid(IModFile modFile) {
        return this.dummyModFiles.contains(modFile) || super.isValid(modFile);
    }

    public void initArguments(Map<String, ?> arguments) {
        Environment env = Launcher.INSTANCE.environment();
        ForgePluginPlatform.bootstrap(env);
        this.libraryManager = new LibraryManager(env.getProperty(ForgeProductionBootstrap.Keys.CHECK_LIBRARY_HASHES.get()).orElse(true), (Path)env.getProperty(ForgeProductionBootstrap.Keys.LIBRARIES_DIRECTORY.get()).orElseThrow(() -> new IllegalStateException("no libraries available")), ForgeBootstrap.class.getResource("libraries.json"));
    }

    private boolean isTCLExcluded(Path excluded) {
        String path = excluded.toString();
        for (String test : EXCLUDED_PATHS) {
            if (!path.startsWith(test)) continue;
            return true;
        }
        return false;
    }

    private boolean isLibrary(Path path) {
        String completePath = path.toString();
        return completePath.contains("kyori") || completePath.contains("SpongeAPI" + File.separator + "build" + File.separator + "libs");
    }

    private ModFile newDummySpongeFile(IModFile parent, IModLocator locator, String fileName) throws URISyntaxException {
        return (ModFile)ModFileFactory.FACTORY.build(INVALID_PATH, locator, file -> ModFileParsers.dummySpongeModParser(parent, fileName, file));
    }
}

