/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.BufferedReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.NightConfigWrapper;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.forge.applaunch.loading.metadata.PluginFileConfigurable;
import org.spongepowered.plugin.metadata.builtin.MetadataContainer;
import org.spongepowered.plugin.metadata.builtin.MetadataParser;

public final class ModFileParsers {
    private static Constructor<ModFileInfo> modFileInfoConstructor;
    private static Field modFileInfoField;

    public static IModFileInfo dummySpongeModParser(IModFile realModFile, String fileName, IModFile iModFile) {
        ModFile modFile = (ModFile)iModFile;
        AppLaunch.logger().debug("Considering sponge platform candidate {}", (Object)modFile.getFilePath());
        Path modsjson = modFile.getLocator().findPath(realModFile, new String[]{fileName + ".toml"});
        if (!Files.exists(modsjson, new LinkOption[0])) {
            AppLaunch.logger().warn("Sponge platform file '{}' is missing the '{}' file", (Object)modFile, (Object)(fileName + ".toml"));
            return null;
        }
        FileConfig fileConfig = FileConfig.builder((Path)modsjson).build();
        fileConfig.load();
        fileConfig.close();
        NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)fileConfig);
        try {
            return ModFileParsers.generateModFileMetadata(modFile, (IConfigurable)configWrapper);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IModFileInfo pluginMetadataParser(String fileName, IModFile iModFile) {
        ModFile modFile = (ModFile)iModFile;
        AppLaunch.logger().debug("Considering plugin file candidate {}", (Object)modFile.getFilePath());
        Path metadataFile = modFile.getLocator().findPath((IModFile)modFile, new String[]{"META-INF/" + fileName + ".json"});
        if (Files.notExists(metadataFile, new LinkOption[0])) {
            AppLaunch.logger().debug("Plugin file '{}' is missing a 'sponge_plugins.json' metadata file in META-INF", (Object)modFile);
            return null;
        }
        try {
            MetadataContainer container;
            try (BufferedReader reader = Files.newBufferedReader(metadataFile, StandardCharsets.UTF_8);){
                container = MetadataParser.read(reader);
            }
            PluginFileConfigurable configurable = new PluginFileConfigurable(container);
            return ModFileParsers.generateModFileMetadata(modFile, configurable);
        }
        catch (Exception e) {
            AppLaunch.logger().warn("Could not read metadata for plugin file '{}'", (Object)modFile, (Object)e);
            return null;
        }
    }

    private static ModFileInfo generateModFileMetadata(ModFile file, IConfigurable configurable) throws Exception {
        modFileInfoConstructor.setAccessible(true);
        ModFileInfo modFileInfo = modFileInfoConstructor.newInstance(file, configurable);
        modFileInfoConstructor.setAccessible(false);
        if (configurable instanceof NightConfigWrapper) {
            modFileInfoField.setAccessible(true);
            modFileInfoField.set(configurable, modFileInfo);
            modFileInfoField.setAccessible(false);
        }
        return modFileInfo;
    }

    public static ModFile newPluginInstance(Path path, IModLocator locator, String fileName) {
        return (ModFile)ModFileFactory.FACTORY.build(path, locator, file -> ModFileParsers.pluginMetadataParser(fileName, file));
    }

    private ModFileParsers() {
    }

    static {
        try {
            modFileInfoConstructor = ModFileInfo.class.getDeclaredConstructor(ModFile.class, IConfigurable.class);
            modFileInfoField = NightConfigWrapper.class.getDeclaredField("file");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

