/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery.library;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class InstallerUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    private InstallerUtils() {
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean validateSha1(String expectedHash, Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl = InstallerUtils.validateSha1(expectedHash, is);
            return bl;
        }
    }

    public static boolean validateSha1(String expectedHash, InputStream stream) throws IOException {
        int read;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError((Object)ex);
        }
        byte[] buf = new byte[4096];
        while ((read = stream.read(buf)) != -1) {
            digest.update(buf, 0, read);
        }
        return expectedHash.equals(InstallerUtils.toHexString(digest.digest()));
    }

    public static void download(URL url, Path path, boolean requiresRequest) throws IOException {
        block25: {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String name = path.getFileName().toString();
            LOGGER.info("Downloading {}. This may take a while...", (Object)name);
            LOGGER.info("URL -> <{}>", (Object)url);
            if (!requiresRequest) {
                try (ReadableByteChannel in = Channels.newChannel(url.openStream());
                     FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    out.transferFrom(in, 0L, Long.MAX_VALUE);
                    break block25;
                }
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Sponge-Downloader");
            connection.connect();
            try (ReadableByteChannel in = Channels.newChannel(connection.getInputStream());
                 FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                out.transferFrom(in, 0L, Long.MAX_VALUE);
            }
        }
    }

    public static void downloadCheckHash(URL url, Path path, MessageDigest digest, String expected, boolean requiresRequest) throws IOException {
        String name;
        block36: {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            name = path.getFileName().toString();
            LOGGER.info("Downloading {}. This may take a while...", (Object)name);
            LOGGER.debug("URL -> <{}>", (Object)url);
            if (!requiresRequest) {
                try (DigestInputStream stream = new DigestInputStream(url.openStream(), digest);
                     ReadableByteChannel in = Channels.newChannel(stream);
                     FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    out.transferFrom(in, 0L, Long.MAX_VALUE);
                    break block36;
                }
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Sponge-Downloader");
            connection.connect();
            try (DigestInputStream stream = new DigestInputStream(connection.getInputStream(), digest);
                 ReadableByteChannel in = Channels.newChannel(stream);
                 FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                out.transferFrom(in, 0L, Long.MAX_VALUE);
            }
        }
        String fileSha1 = InstallerUtils.toHexString(digest.digest());
        if (!expected.equalsIgnoreCase(fileSha1)) {
            Files.delete(path);
            throw new IOException(String.format("Checksum verification failed: Expected '%s', got '%s'.", expected, fileSha1));
        }
        LOGGER.info("Successfully downloaded {} and verified checksum!", (Object)name);
    }
}

