/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery.library;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.AsyncUtils;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.InstallerUtils;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.model.sponge.Libraries;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.model.sponge.SonatypeResponse;

public final class LibraryManager {
    public static final String SPONGE_NEXUS_DOWNLOAD_URL = "https://repo.spongepowered.org/service/rest/v1/search/assets?md5=%s&maven.groupId=%s&maven.artifactId=%s&maven.baseVersion=%s&maven.extension=jar";
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean checkLibraryHashes;
    private final Path rootDirectory;
    private final URL librariesUrl;
    private final Map<String, Library> libraries;
    private final ExecutorService preparationWorker;

    public LibraryManager(boolean checkLibraryHashes, Path rootDirectory, URL librariesUrl) {
        this.checkLibraryHashes = checkLibraryHashes;
        this.rootDirectory = Objects.requireNonNull(rootDirectory, "rootDirectory");
        this.librariesUrl = Objects.requireNonNull(librariesUrl, "librariesUrl");
        this.libraries = new LinkedHashMap<String, Library>();
        int availableCpus = Runtime.getRuntime().availableProcessors();
        this.preparationWorker = new ThreadPoolExecutor(Math.min(Math.max(4, availableCpus * 2), 64), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public Path getRootDirectory() {
        return this.rootDirectory;
    }

    public Map<String, Library> getAll() {
        return Collections.unmodifiableMap(this.libraries);
    }

    protected void addLibrary(Library library) {
        this.libraries.put(library.getName(), library);
    }

    public void validate() throws Exception {
        Libraries dependencies;
        LOGGER.info("Scanning and verifying libraries in '{}'. Please wait, this may take a moment...", (Object)this.rootDirectory);
        Gson gson = new Gson();
        try (JsonReader reader = new JsonReader(new InputStreamReader(this.librariesUrl.openStream(), StandardCharsets.UTF_8));){
            dependencies = (Libraries)gson.fromJson(reader, (Type)((Object)Libraries.class));
        }
        ConcurrentHashMap.KeySetView downloadedDeps = ConcurrentHashMap.newKeySet();
        ArrayList<CompletableFuture<Object>> operations = new ArrayList<CompletableFuture<Object>>(dependencies.dependencies.size());
        ConcurrentHashMap.KeySetView failures = ConcurrentHashMap.newKeySet();
        for (Libraries.Dependency dependency : dependencies.dependencies.get("main")) {
            operations.add(AsyncUtils.asyncFailableFuture(() -> {
                String groupPath = dependency.group.replace(".", "/");
                Path depDirectory = this.rootDirectory.resolve(groupPath).resolve(dependency.module).resolve(dependency.version);
                Files.createDirectories(depDirectory, new FileAttribute[0]);
                Path depFile = depDirectory.resolve(dependency.module + "-" + dependency.version + ".jar");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                boolean checkHashes = this.checkLibraryHashes;
                if (Files.exists(depFile, new LinkOption[0])) {
                    if (!checkHashes) {
                        LOGGER.info("Detected existing '{}', skipping hash checks...", (Object)depFile);
                        downloadedDeps.add(new Library(dependency.group + "-" + dependency.module, depFile));
                        return null;
                    }
                    byte[] bytes = Files.readAllBytes(depFile);
                    String fileMd5 = InstallerUtils.toHexString(md5.digest(bytes));
                    if (dependency.md5.equals(fileMd5)) {
                        LOGGER.debug("'{}' verified!", (Object)depFile);
                    } else {
                        LOGGER.error("Checksum verification failed: Expected {}, {}. Deleting cached '{}'...", (Object)dependency.md5, (Object)fileMd5, (Object)depFile);
                        Files.delete(depFile);
                        SonatypeResponse response = this.getResponseFor(gson, dependency);
                        if (response.items.isEmpty()) {
                            failures.add("No data received from '" + new URL(String.format(SPONGE_NEXUS_DOWNLOAD_URL, dependency.md5, dependency.group, dependency.module, dependency.version)) + "'!");
                            return null;
                        }
                        SonatypeResponse.Item item = response.items.get(0);
                        URL url = item.downloadUrl;
                        InstallerUtils.downloadCheckHash(url, depFile, md5, item.checksum.md5, true);
                    }
                } else {
                    SonatypeResponse response = this.getResponseFor(gson, dependency);
                    if (response.items.isEmpty()) {
                        failures.add("No data received from '" + new URL(String.format(SPONGE_NEXUS_DOWNLOAD_URL, dependency.md5, dependency.group, dependency.module, dependency.version)) + "'!");
                        return null;
                    }
                    SonatypeResponse.Item item = response.items.get(0);
                    URL url = item.downloadUrl;
                    if (checkHashes) {
                        InstallerUtils.downloadCheckHash(url, depFile, md5, item.checksum.md5, true);
                    } else {
                        InstallerUtils.download(url, depFile, true);
                    }
                }
                downloadedDeps.add(new Library(dependency.group + "-" + dependency.module, depFile));
                return null;
            }, this.preparationWorker));
        }
        ((CompletableFuture)CompletableFuture.allOf(operations.toArray(new CompletableFuture[0])).handle((result, err) -> {
            if (err != null) {
                failures.add(err.getMessage());
                LOGGER.error("Failed to download library", (Throwable)err);
            }
            return result;
        })).join();
        if (!failures.isEmpty()) {
            LOGGER.error("Failed to download some libraries:");
            for (String message : failures) {
                LOGGER.error(message);
            }
            System.exit(-1);
        }
        for (Library library : downloadedDeps) {
            this.libraries.put(library.getName(), library);
        }
    }

    private SonatypeResponse getResponseFor(Gson gson, Libraries.Dependency dependency) throws IOException {
        URL requestUrl = new URL(String.format(SPONGE_NEXUS_DOWNLOAD_URL, dependency.md5, dependency.group, dependency.module, dependency.version));
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Sponge-Downloader");
        connection.connect();
        try (JsonReader reader = new JsonReader(new InputStreamReader(connection.getInputStream()));){
            SonatypeResponse sonatypeResponse = (SonatypeResponse)gson.fromJson(reader, (Type)((Object)SonatypeResponse.class));
            return sonatypeResponse;
        }
    }

    public ExecutorService preparationWorker() {
        return this.preparationWorker;
    }

    public void finishedProcessing() {
        boolean successful;
        if (this.preparationWorker.isTerminated()) {
            return;
        }
        this.preparationWorker.shutdown();
        try {
            successful = this.preparationWorker.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            successful = false;
        }
        if (!successful) {
            LOGGER.warn("Failed to shut down library preparation pool in 10 seconds, forcing shutdown now.");
            this.preparationWorker.shutdownNow();
        }
    }

    public static class Library {
        private final String name;
        private final Path file;

        public Library(String name, Path file) {
            this.name = name;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

