/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery.locator;

import com.google.common.base.Predicates;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.forge.applaunch.loading.moddiscovery.ModFileParsers;

public final class ClasspathPluginLocator
extends AbstractJarFileLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PLUGINS_JSON = "META-INF/sponge_plugins.json";
    private Set<Path> modCoords;

    public List<IModFile> scanMods() {
        return this.modCoords.stream().map(mc -> ModFileParsers.newPluginInstance(mc, (IModLocator)this, "sponge_plugins")).peek(f -> this.modJars.compute(f, (mf, fs) -> this.createFileSystem((IModFile)mf))).collect(Collectors.toList());
    }

    public String name() {
        return "plugin classpath";
    }

    public void initArguments(Map<String, ?> arguments) {
        try {
            this.modCoords = new LinkedHashSet<Path>();
            this.locateMods(PLUGINS_JSON, "classpath_plugin", (Predicate<Path>)Predicates.alwaysTrue());
        }
        catch (IOException e) {
            LOGGER.fatal(Logging.CORE, "Error trying to find resources", (Throwable)e);
            throw new RuntimeException("wha?", e);
        }
    }

    private void locateMods(String resource, String name, Predicate<Path> filter) throws IOException {
        Enumeration<URL> pluginJsons = ClassLoader.getSystemClassLoader().getResources(resource);
        while (pluginJsons.hasMoreElements()) {
            URL url = pluginJsons.nextElement();
            Path path = LibraryFinder.findJarPathFor((String)resource, (String)name, (URL)url);
            if (Files.isDirectory(path, new LinkOption[0]) || !filter.test(path)) continue;
            LOGGER.debug(Logging.CORE, "Found classpath plugin: {}", (Object)path);
            this.modCoords.add(path);
        }
    }
}

