/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery.locator;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.forge.applaunch.loading.moddiscovery.ModFileParsers;

public final class PluginsFolderLocator
extends AbstractJarFileLocator {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<IModFile> scanMods() {
        List<Path> pluginDirectories = AppLaunch.pluginPlatform().pluginDirectories();
        ArrayList<IModFile> modFiles = new ArrayList<IModFile>();
        for (Path pluginDirectory : pluginDirectories) {
            LOGGER.debug(LogMarkers.SCAN, "Scanning plugins directory '{}' for plugins", (Object)pluginDirectory);
            modFiles.addAll(this.scanForModsIn(pluginDirectory));
        }
        return modFiles;
    }

    private List<IModFile> scanForModsIn(Path pluginsDirectory) {
        List excluded = ModDirTransformerDiscoverer.allExcluded();
        return ((Stream)LamdbaExceptionUtils.uncheck(() -> Files.list(pluginsDirectory))).filter(p -> !excluded.contains(p)).sorted(Comparator.comparing(path -> StringUtils.toLowerCase((String)path.getFileName().toString()))).filter(p -> StringUtils.toLowerCase((String)p.getFileName().toString()).endsWith(".jar")).map(p -> ModFileParsers.newPluginInstance(p, (IModLocator)this, "sponge_plugins")).peek(f -> this.modJars.compute(f, (mf, fs) -> this.createFileSystem((IModFile)mf))).filter(f -> {
            if (!f.identifyMods()) {
                FileSystem fs = (FileSystem)this.modJars.remove(f);
                if (fs != null) {
                    LamdbaExceptionUtils.uncheck(fs::close);
                }
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public String name() {
        return "plugins directory";
    }

    public void initArguments(Map<String, ?> arguments) {
    }
}

