/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery.provider;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLanguageProvider;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public final class JavaPluginLanguageProvider
extends FMLJavaModLanguageProvider {
    private static final Type PLUGIN_ANNOTATION = Type.getType((String)"Lorg/spongepowered/plugin/builtin/jvm/Plugin;");
    private final Logger logger = LogManager.getLogger();

    public String name() {
        return "java_plain";
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        return scanResult -> {
            Map modTargetMap = scanResult.getAnnotations().stream().filter(ad -> ad.getAnnotationType().equals((Object)PLUGIN_ANNOTATION)).peek(ad -> this.logger.debug(Logging.SCAN, "Found @Plugin class {} with id {}", (Object)ad.getClassType().getClassName(), ad.getAnnotationData().get("value"))).map(ad -> new PluginTarget(ad.getClassType().getClassName(), (String)ad.getAnnotationData().get("value"))).collect(Collectors.toMap(PluginTarget::getPlugin, Function.identity(), (a, b) -> a));
            scanResult.addLanguageLoader(modTargetMap);
        };
    }

    private static final class PluginTarget
    implements IModLanguageProvider.IModLanguageLoader {
        private final Logger logger = LogManager.getLogger();
        private final String className;
        private final String plugin;

        private PluginTarget(String className, String plugin) {
            this.className = className;
            this.plugin = plugin;
        }

        public <T> T loadMod(IModInfo info, ClassLoader modClassLoader, ModFileScanData modFileScanResults) {
            try {
                Class<?> pluginContainer = Class.forName("org.spongepowered.forge.launch.plugin.PluginModContainer", true, Thread.currentThread().getContextClassLoader());
                this.logger.debug(Logging.LOADING, "Loading PluginModContainer from classloader {} - got {}", (Object)Thread.currentThread().getContextClassLoader(), (Object)pluginContainer.getClassLoader());
                Constructor<?> constructor = pluginContainer.getConstructor(IModInfo.class, String.class, ClassLoader.class, ModFileScanData.class);
                return (T)constructor.newInstance(info, this.className, modClassLoader, modFileScanResults);
            }
            catch (InvocationTargetException e) {
                this.logger.fatal(Logging.LOADING, "Failed to build plugin", (Throwable)e);
                Class mle = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingException", true, Thread.currentThread().getContextClassLoader()));
                if (mle.isInstance(e.getTargetException())) {
                    throw (RuntimeException)mle.cast(e.getTargetException());
                }
                Class mls = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingStage", true, Thread.currentThread().getContextClassLoader()));
                throw (RuntimeException)LamdbaExceptionUtils.uncheck(() -> (RuntimeException)((Constructor)LamdbaExceptionUtils.uncheck(() -> mle.getConstructor(IModInfo.class, mls, String.class, Throwable.class))).newInstance(info, Enum.valueOf(mls, "CONSTRUCT"), "fml.modloading.failedtoloadmodclass", e));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                this.logger.fatal(Logging.LOADING, "Unable to load PluginModContainer, excuse me?", (Throwable)e);
                Class mle = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingException", true, Thread.currentThread().getContextClassLoader()));
                Class mls = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingStage", true, Thread.currentThread().getContextClassLoader()));
                throw (RuntimeException)LamdbaExceptionUtils.uncheck(() -> (RuntimeException)((Constructor)LamdbaExceptionUtils.uncheck(() -> mle.getConstructor(IModInfo.class, mls, String.class, Throwable.class))).newInstance(info, Enum.valueOf(mls, "CONSTRUCT"), "fml.modloading.failedtoloadmodclass", e));
            }
        }

        public String getPlugin() {
            return this.plugin;
        }
    }
}

