/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.plugin;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;

public final class ForgePluginPlatform
implements PluginPlatform {
    private static volatile boolean bootstrapped;
    private final Environment environment;
    private final Logger logger;
    private final List<Path> pluginDirectories;

    public static synchronized boolean bootstrap(Environment environment) {
        if (bootstrapped) {
            return false;
        }
        bootstrapped = true;
        ForgePluginPlatform platform = new ForgePluginPlatform(environment);
        AppLaunch.setPluginPlatform(platform);
        platform.init();
        return true;
    }

    private ForgePluginPlatform(Environment environment) {
        this.environment = environment;
        this.logger = LogManager.getLogger("plugin");
        this.pluginDirectories = new ArrayList<Path>();
        this.pluginDirectories.add(FMLPaths.MODSDIR.get());
    }

    @Override
    public String version() {
        return this.environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get()).orElse("dev");
    }

    @Override
    public void setVersion(String version) {
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public Path baseDirectory() {
        return this.environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElse(Paths.get(".", new String[0]));
    }

    @Override
    public void setBaseDirectory(Path baseDirectory) {
    }

    @Override
    public List<Path> pluginDirectories() {
        return Collections.unmodifiableList(this.pluginDirectories);
    }

    @Override
    public void setPluginDirectories(List<Path> pluginDirectories) {
    }

    @Override
    public String metadataFilePath() {
        return null;
    }

    @Override
    public void setMetadataFilePath(String metadataFilePath) {
    }

    public void init() {
        Path alternativePluginsDirectory = Paths.get(SpongeConfigs.getCommon().get().general.pluginsDir.getParsed(), new String[0]);
        try {
            Files.createDirectories(alternativePluginsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pluginDirectories.add(alternativePluginsDirectory);
    }
}

