/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.service;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.transformers.modlauncher.AccessWidenerTransformationService;
import org.spongepowered.transformers.modlauncher.SuperclassChanger;

public class ForgeProductionBootstrap
implements ITransformationService {
    public static final String NAME = "spongeforge";
    private OptionSpec<Boolean> checkHashes;
    private OptionSpec<String> librariesDirectoryName;

    public @NonNull String name() {
        return NAME;
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.checkHashes = argumentBuilder.apply("checkHashes", "Whether to check hashes when downloading libraries").withOptionalArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        this.librariesDirectoryName = argumentBuilder.apply("librariesDir", "The directory to download SpongeForge libraries to").withOptionalArg().ofType(String.class).defaultsTo((Object)"sponge-libraries", (Object[])new String[0]);
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        Launcher.INSTANCE.environment().computePropertyIfAbsent(Keys.CHECK_LIBRARY_HASHES.get(), $ -> (Boolean)option.value(this.checkHashes));
        Launcher.INSTANCE.environment().computePropertyIfAbsent(Keys.LIBRARIES_DIRECTORY.get(), $ -> ((Path)Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElseThrow(() -> new IllegalStateException("No game directory was available"))).resolve((String)option.value(this.librariesDirectoryName)));
    }

    public void initialize(IEnvironment environment) {
        if (FMLEnvironment.production) {
            try {
                ModDirTransformerDiscoverer.getExtraLocators().add(Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()));
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Failed to register SpongeForge", ex);
            }
            environment.getProperty(AccessWidenerTransformationService.INSTANCE.get()).ifPresent(aWTS -> aWTS.offerResource(ForgeProductionBootstrap.class.getResource("/common.accesswidener"), "SpongeForge injected"));
            environment.getProperty(SuperclassChanger.INSTANCE.get()).ifPresent(scc -> {
                scc.offerResource(ForgeProductionBootstrap.class.getResource("/common.superclasschange"), "SpongeForge injected");
                scc.offerResource(ForgeProductionBootstrap.class.getResource("/forge.superclasschange"), "SpongeForge injected");
            });
        }
    }

    public void beginScanning(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    public @NonNull List<ITransformer> transformers() {
        return Collections.emptyList();
    }

    public static final class Keys {
        public static final Supplier<TypesafeMap.Key<Boolean>> CHECK_LIBRARY_HASHES = IEnvironment.buildKey((String)"sponge:check_library_hashes", Boolean.class);
        public static final Supplier<TypesafeMap.Key<Path>> LIBRARIES_DIRECTORY = IEnvironment.buildKey((String)"sponge:libraries_directory", Path.class);

        private Keys() {
        }
    }
}

