/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.hook;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.common.hooks.EventHooks;

public final class ForgeEventHooks
implements EventHooks {
    @Override
    public ChangeEntityWorldEvent.Pre callChangeEntityWorldEventPre(Entity entity, ServerWorld toWorld) {
        ChangeEntityWorldEvent.Pre pre = EventHooks.super.callChangeEntityWorldEventPre(entity, toWorld);
        if (pre.isCancelled() && entity instanceof ContainerMinecartEntity) {
            ((ContainerMinecartEntity)entity).dropContentsWhenDead(true);
        }
        return pre;
    }

    @Override
    public void callItemDestroyedEvent(PlayerEntity player, ItemStack stack, Hand hand) {
        ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)stack, (Hand)Hand.MAIN_HAND);
    }

    @Override
    public EventHooks.CriticalHitResult callCriticalHitEvent(PlayerEntity player, Entity targetEntity, boolean isCriticalAttack, float v) {
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)player, (Entity)targetEntity, (boolean)isCriticalAttack, (float)v);
        if (hitResult != null) {
            return new EventHooks.CriticalHitResult(true, hitResult.getDamageModifier() - 1.0f);
        }
        return new EventHooks.CriticalHitResult(false, v);
    }
}

