/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.launch;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.ArrayList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;
import org.spongepowered.common.inject.SpongeCommonModule;
import org.spongepowered.common.inject.SpongeModule;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.mapping.SpongeMappingManager;
import org.spongepowered.forge.applaunch.loading.metadata.PluginMetadataUtils;
import org.spongepowered.forge.launch.ForgeMappingManager;
import org.spongepowered.forge.launch.inject.SpongeForgeModule;
import org.spongepowered.forge.launch.plugin.ForgePluginManager;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;

public final class ForgeLaunch
extends Launch {
    private final ForgePluginManager pluginManager;
    private PluginContainer spongeForgePlugin;
    private final ForgeMappingManager mappings = new ForgeMappingManager();

    public ForgeLaunch(PluginPlatform platform) {
        super(platform);
        this.pluginManager = new ForgePluginManager();
    }

    @Override
    public boolean dedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public ForgePluginManager pluginManager() {
        return this.pluginManager;
    }

    @Override
    public SpongeMappingManager mappingManager() {
        return this.mappings;
    }

    @Override
    public Stage injectionStage() {
        return FMLLoader.isProduction() ? Stage.PRODUCTION : Stage.DEVELOPMENT;
    }

    @Override
    public Injector createInjector() {
        ArrayList modules = Lists.newArrayList((Object[])new Module[]{new SpongeModule(), new SpongeCommonModule(), new SpongeForgeModule()});
        return Guice.createInjector((Stage)this.injectionStage(), (Iterable)modules);
    }

    @Override
    public PluginContainer platformPlugin() {
        if (this.spongeForgePlugin == null) {
            this.spongeForgePlugin = this.pluginManager().plugin("spongeforge").orElse(null);
            if (this.spongeForgePlugin == null) {
                throw new RuntimeException("Could not find the plugin representing SpongeForge, this is a serious issue!");
            }
        }
        return this.spongeForgePlugin;
    }

    public PluginMetadata metadataForMod(ModInfo info) {
        return PluginMetadataUtils.modToPlugin(info);
    }
}

