/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.launch.command;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.command.sponge.SpongeCommand;

public final class ForgeCommandManager
extends SpongeCommandManager {
    @Inject
    public ForgeCommandManager(Game game, Provider<SpongeCommand> spongeCommand) {
        super(game, spongeCommand);
    }

    @Override
    protected CommandResult processCommand(CommandCause cause, CommandMapping mapping, String original, String command, String args) throws Throwable {
        ParseResults parseResults;
        CommandRegistrar<?> registrar = mapping.registrar();
        boolean isBrig = registrar instanceof BrigadierBasedRegistrar;
        if (isBrig) {
            parseResults = this.getDispatcher().parse(original, (CommandSource)cause);
        } else {
            CommandContextBuilder contextBuilder = new CommandContextBuilder((CommandDispatcher)this.getDispatcher(), (Object)((CommandSource)cause), (CommandNode)this.getDispatcher().getRoot(), 0);
            contextBuilder.withCommand(ctx -> 1);
            if (!args.isEmpty()) {
                contextBuilder.withArgument("parsed", new ParsedArgument(command.length(), original.length(), (Object)args));
            }
            parseResults = new ParseResults(contextBuilder, (ImmutableStringReader)new SpongeStringReader(original), Collections.emptyMap());
        }
        CommandEvent event = new CommandEvent(parseResults);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (event.getException() != null) {
                Throwables.throwIfUnchecked((Throwable)event.getException());
            }
            return CommandResult.builder().result(0).build();
        }
        if (isBrig) {
            return CommandResult.builder().result(this.getDispatcher().execute(parseResults)).build();
        }
        return mapping.registrar().process(cause, mapping, command, args);
    }
}

