/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.launch.event;

import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventBusInvokeDispatcher;
import net.minecraftforge.eventbus.api.IEventListener;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.manager.RegisteredListener;
import org.spongepowered.common.event.manager.SpongeEventManager;
import org.spongepowered.forge.launch.bridge.event.ForgeEventBridge_Forge;
import org.spongepowered.forge.launch.bridge.event.SpongeEventBridge_Forge;

@Singleton
public final class ForgeEventManager
extends SpongeEventManager
implements IEventBus {
    private final IEventBus wrappedEventBus;

    public ForgeEventManager(IEventBus eventBus) {
        this.wrappedEventBus = eventBus;
    }

    public void register(Object target) {
        this.wrappedEventBus.register(target);
    }

    public <T extends net.minecraftforge.eventbus.api.Event> void addListener(Consumer<T> consumer) {
        this.wrappedEventBus.addListener(consumer);
    }

    public <T extends net.minecraftforge.eventbus.api.Event> void addListener(EventPriority priority, Consumer<T> consumer) {
        this.wrappedEventBus.addListener(priority, consumer);
    }

    public <T extends net.minecraftforge.eventbus.api.Event> void addListener(EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.wrappedEventBus.addListener(priority, receiveCancelled, consumer);
    }

    public <T extends net.minecraftforge.eventbus.api.Event> void addListener(EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        this.wrappedEventBus.addListener(priority, receiveCancelled, eventType, consumer);
    }

    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, Consumer<T> consumer) {
        this.wrappedEventBus.addGenericListener(genericClassFilter, consumer);
    }

    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, Consumer<T> consumer) {
        this.wrappedEventBus.addGenericListener(genericClassFilter, priority, consumer);
    }

    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.wrappedEventBus.addGenericListener(genericClassFilter, priority, receiveCancelled, consumer);
    }

    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        this.wrappedEventBus.addGenericListener(genericClassFilter, priority, receiveCancelled, eventType, consumer);
    }

    public void unregister(Object object) {
        this.wrappedEventBus.unregister(object);
    }

    public boolean post(net.minecraftforge.eventbus.api.Event event) {
        return this.post(event, IEventListener::invoke);
    }

    public boolean post(net.minecraftforge.eventbus.api.Event event, IEventBusInvokeDispatcher wrapper) {
        ForgeEventBridge_Forge forgeEvent;
        Event spongeEvent;
        if (event instanceof ForgeEventBridge_Forge && (spongeEvent = (forgeEvent = (ForgeEventBridge_Forge)event).bridge$createSpongeEvent()) != null) {
            return this.postDualBus(spongeEvent, Collections.singleton(event), wrapper);
        }
        return this.wrappedEventBus.post(event, wrapper);
    }

    public void shutdown() {
        this.wrappedEventBus.shutdown();
    }

    public void start() {
        this.wrappedEventBus.start();
    }

    @Override
    public boolean post(Event event) {
        SpongeEventBridge_Forge eventBridge = (SpongeEventBridge_Forge)((Object)event);
        @Nullable Collection<? extends net.minecraftforge.eventbus.api.Event> forgeEvents = eventBridge.bridge$createForgeEvents();
        if (forgeEvents == null || forgeEvents.isEmpty()) {
            return super.post(event);
        }
        return this.postDualBus(event, forgeEvents, eventBridge.bridge$eventDispatcher());
    }

    private boolean postDualBus(Event spongeEvent, Collection<? extends net.minecraftforge.eventbus.api.Event> forgeEvents, IEventBusInvokeDispatcher dispatcher) {
        try (SpongeEventManager.NoExceptionClosable ignored = this.preparePost(spongeEvent);){
            RegisteredListener.Cache listeners = this.getHandlerCache(spongeEvent);
            List<RegisteredListener<?>> beforeModifications = listeners.beforeModifications();
            if (!beforeModifications.isEmpty()) {
                this.post(spongeEvent, beforeModifications);
                for (net.minecraftforge.eventbus.api.Event event : forgeEvents) {
                    ((ForgeEventBridge_Forge)event).bridge$syncFrom(spongeEvent);
                }
            }
            for (net.minecraftforge.eventbus.api.Event event : forgeEvents) {
                this.wrappedEventBus.post(event, dispatcher);
                ((ForgeEventBridge_Forge)event).bridge$syncTo(spongeEvent);
            }
            boolean bl = this.post(spongeEvent, listeners.afterModifications());
            return bl;
        }
    }
}

