/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.launch.event;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventBusInvokeDispatcher;
import net.minecraftforge.eventbus.api.IEventExceptionHandler;
import net.minecraftforge.eventbus.api.IEventListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.event.manager.SpongeEventManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.EventListenerPhaseContext;

public final class SpongeEventBus
extends EventBus {
    private static Field checkTypesOnDispatchField;
    private static Field busIDField;
    private static Field exceptionHandler;
    private final BusBuilder builder;
    private final boolean rcheckTypesOnDispatch;
    private final int rbusID;
    private final IEventExceptionHandler rexceptionHandler;
    private boolean rshutdown;

    public SpongeEventBus(BusBuilder busBuilder) {
        super(busBuilder);
        this.builder = busBuilder;
        this.rshutdown = busBuilder.isStartingShutdown();
        try {
            checkTypesOnDispatchField.setAccessible(true);
            busIDField.setAccessible(true);
            exceptionHandler.setAccessible(true);
            this.rcheckTypesOnDispatch = checkTypesOnDispatchField.getBoolean(null);
            this.rbusID = busIDField.getInt((Object)this);
            this.rexceptionHandler = (IEventExceptionHandler)exceptionHandler.get((Object)this);
            checkTypesOnDispatchField.setAccessible(false);
            busIDField.setAccessible(false);
            exceptionHandler.setAccessible(false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean post(Event event, IEventBusInvokeDispatcher wrapper) {
        if (this.rshutdown) {
            return false;
        }
        if (this.rcheckTypesOnDispatch && !this.builder.getMarkerType().isInstance(event)) {
            throw new IllegalArgumentException("Cannot post event of type " + event.getClass().getSimpleName() + " to this event. Must match type: " + this.builder.getMarkerType().getSimpleName());
        }
        IEventListener[] listeners = event.getListenerList().getListeners(this.rbusID);
        for (int index = 0; index < listeners.length; ++index) {
            IEventListener listener = listeners[index];
            if (!this.builder.getTrackPhases() && Objects.equals(listener.getClass(), EventPriority.class)) continue;
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();
                 @NonNull EventListenerPhaseContext context = SpongeEventManager.createListenerContext(null);){
                if (context != null) {
                    context.buildAndSwitch();
                }
                wrapper.invoke(listener, event);
                continue;
            }
            catch (Throwable t2) {
                this.rexceptionHandler.handleException((IEventBus)this, event, listeners, index, t2);
            }
        }
        return event.isCancelable() && event.isCanceled();
    }

    public void shutdown() {
        super.shutdown();
        this.rshutdown = true;
    }

    public void start() {
        super.start();
        this.rshutdown = false;
    }

    static {
        try {
            checkTypesOnDispatchField = EventBus.class.getDeclaredField("checkTypesOnDispatch");
            busIDField = EventBus.class.getDeclaredField("busID");
            exceptionHandler = EventBus.class.getDeclaredField("exceptionHandler");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

