/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.launch.plugin;

import com.google.inject.Injector;
import com.google.inject.Module;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.AutomaticEventSubscriber;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.inject.plugin.PluginModule;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.forge.accessor.fml.javafmlmod.FMLModContainerAccessor;
import org.spongepowered.forge.launch.event.ForgeEventManager;
import org.spongepowered.plugin.PluginContainer;

public final class PluginModContainer
extends FMLModContainer {
    private static final Logger LOGGER = LogManager.getLogger();

    public PluginModContainer(IModInfo info, String className, ClassLoader modClassLoader, ModFileScanData modFileScanResults) {
        super(info, className, modClassLoader, modFileScanResults);
        this.activityMap.put(ModLoadingStage.CONSTRUCT, this::constructPlugin);
    }

    private void constructPlugin() {
        FMLModContainerAccessor accessor = (FMLModContainerAccessor)((Object)this);
        try {
            LOGGER.trace(Logging.LOADING, "Loading plugin instance {} of type {}", (Object)this.getModId(), (Object)accessor.accessor$modClass().getName());
            Injector childInjector = ((Launch)Launch.instance()).lifecycle().platformInjector().createChildInjector(new Module[]{new PluginModule((PluginContainer)((Object)this), accessor.accessor$modClass())});
            Object instance = childInjector.getInstance(accessor.accessor$modClass());
            accessor.accessor$setModInstance(instance);
            ((ForgeEventManager)MinecraftForge.EVENT_BUS).registerListeners((PluginContainer)((Object)this), instance);
            LOGGER.trace(Logging.LOADING, "Loaded plugin instance {} of type {}", (Object)this.getModId(), (Object)accessor.accessor$modClass().getName());
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Failed to create plugin instance. PluginID: {}, class {}", (Object)this.getModId(), (Object)accessor.accessor$modClass().getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{accessor.accessor$modClass()});
        }
        try {
            LOGGER.trace(Logging.LOADING, "Injecting Automatic event subscribers for {}", (Object)this.getModId());
            AutomaticEventSubscriber.inject((ModContainer)this, (ModFileScanData)accessor.accessor$scanResults(), (ClassLoader)accessor.accessor$modClass().getClassLoader());
            LOGGER.trace(Logging.LOADING, "Completed Automatic event subscribers for {}", (Object)this.getModId());
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Failed to register automatic subscribers. PluginID: {}, class {}", (Object)this.getModId(), (Object)accessor.accessor$modClass().getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{accessor.accessor$modClass()});
        }
    }
}

