/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.libs.accesswidener;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.spongepowered.forge.libs.accesswidener.EntryTriple;

public final class AccessWidener {
    String namespace;
    final Map<String, Access> classAccess = new HashMap<String, Access>();
    final Map<EntryTriple, Access> methodAccess = new HashMap<EntryTriple, Access>();
    final Map<EntryTriple, Access> fieldAccess = new HashMap<EntryTriple, Access>();
    final Set<String> classes = new LinkedHashSet<String>();

    void addOrMerge(Map<EntryTriple, Access> map, EntryTriple entry, Access access) {
        if (entry == null || access == null) {
            throw new RuntimeException("Input entry or access is null");
        }
        Access merged = null;
        if (access instanceof ClassAccess) {
            merged = ClassAccess.DEFAULT;
        } else if (access instanceof MethodAccess) {
            merged = MethodAccess.DEFAULT;
        } else if (access instanceof FieldAccess) {
            merged = FieldAccess.DEFAULT;
        }
        merged = AccessWidener.mergeAccess(merged, access);
        map.put(entry, merged);
    }

    private static Access mergeAccess(Access a, Access b) {
        Access access = a;
        if (b == ClassAccess.ACCESSIBLE || b == MethodAccess.ACCESSIBLE || b == FieldAccess.ACCESSIBLE || b == MethodAccess.ACCESSIBLE_EXTENDABLE || b == ClassAccess.ACCESSIBLE_EXTENDABLE || b == FieldAccess.ACCESSIBLE_MUTABLE) {
            access = access.makeAccessible();
        }
        if (b == ClassAccess.EXTENDABLE || b == MethodAccess.EXTENDABLE || b == MethodAccess.ACCESSIBLE_EXTENDABLE || b == ClassAccess.ACCESSIBLE_EXTENDABLE) {
            access = access.makeExtendable();
        }
        if (b == FieldAccess.MUTABLE || b == FieldAccess.ACCESSIBLE_MUTABLE) {
            access = access.makeMutable();
        }
        return access;
    }

    void addOrMerge(Map<EntryTriple, Access> map, EntryTriple entry, String access, Access defaultAccess) {
        if (entry == null || access == null) {
            throw new RuntimeException("Input entry or access is null");
        }
        map.put(entry, this.applyAccess(access, map.getOrDefault(entry, defaultAccess), entry));
    }

    Access applyAccess(String input, Access access, EntryTriple entryTriple) {
        switch (input.toLowerCase(Locale.ROOT)) {
            case "accessible": {
                this.makeClassAccessible(entryTriple);
                return access.makeAccessible();
            }
            case "extendable": {
                this.makeClassExtendable(entryTriple);
                return access.makeExtendable();
            }
            case "mutable": {
                return access.makeMutable();
            }
        }
        throw new UnsupportedOperationException("Unknown access type:" + input);
    }

    private void makeClassAccessible(EntryTriple entryTriple) {
        if (entryTriple == null) {
            return;
        }
        this.classAccess.put(entryTriple.getOwner(), this.applyAccess("accessible", this.classAccess.getOrDefault(entryTriple.getOwner(), ClassAccess.DEFAULT), null));
    }

    private void makeClassExtendable(EntryTriple entryTriple) {
        if (entryTriple == null) {
            return;
        }
        this.classAccess.put(entryTriple.getOwner(), this.applyAccess("extendable", this.classAccess.getOrDefault(entryTriple.getOwner(), ClassAccess.DEFAULT), null));
    }

    Access getClassAccess(String className) {
        return this.classAccess.getOrDefault(className, ClassAccess.DEFAULT);
    }

    Access getFieldAccess(EntryTriple entryTriple) {
        return this.fieldAccess.getOrDefault(entryTriple, FieldAccess.DEFAULT);
    }

    Access getMethodAccess(EntryTriple entryTriple) {
        return this.methodAccess.getOrDefault(entryTriple, MethodAccess.DEFAULT);
    }

    public Set<String> getTargets() {
        return this.classes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private static int makePublic(int i) {
        return i & 0xFFFFFFF9 | 1;
    }

    private static int makeProtected(int i) {
        if ((i & 1) != 0) {
            return i;
        }
        return i & 0xFFFFFFFD | 4;
    }

    private static int makeFinalIfPrivate(int access, String name, int ownerAccess) {
        if (name.equals("<init>")) {
            return access;
        }
        if ((ownerAccess & 0x200) != 0 || (access & 8) != 0) {
            return access;
        }
        if ((access & 2) != 0) {
            return access | 0x10;
        }
        return access;
    }

    private static int removeFinal(int i) {
        return i & 0xFFFFFFEF;
    }

    static enum ClassAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(access)),
        EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access))),
        ACCESSIBLE_EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private ClassAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == EXTENDABLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return EXTENDABLE;
        }

        @Override
        public Access makeMutable() {
            throw new UnsupportedOperationException("Classes cannot be made mutable");
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    static enum MethodAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.makeFinalIfPrivate(access, name, ownerAccess))),
        EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$200(AccessWidener.removeFinal(access))),
        ACCESSIBLE_EXTENDABLE((access, name, owner) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private MethodAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == EXTENDABLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return EXTENDABLE;
        }

        @Override
        public Access makeMutable() {
            throw new UnsupportedOperationException("Methods cannot be made mutable");
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    static enum FieldAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(access)),
        MUTABLE((access, name, ownerAccess) -> AccessWidener.access$000(access)),
        ACCESSIBLE_MUTABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private FieldAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == MUTABLE || this == ACCESSIBLE_MUTABLE) {
                return ACCESSIBLE_MUTABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            throw new UnsupportedOperationException("Fields cannot be made extendable");
        }

        @Override
        public Access makeMutable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_MUTABLE) {
                return ACCESSIBLE_MUTABLE;
            }
            return MUTABLE;
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    static interface Access
    extends AccessOperator {
        public Access makeAccessible();

        public Access makeExtendable();

        public Access makeMutable();
    }

    @FunctionalInterface
    static interface AccessOperator {
        public int apply(int var1, String var2, int var3);
    }
}

