/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.libs.accesswidener;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.spongepowered.forge.libs.accesswidener.AccessWidener;
import org.spongepowered.forge.libs.accesswidener.EntryTriple;

public final class AccessWidenerReader {
    private final AccessWidener accessWidener;

    public AccessWidenerReader(AccessWidener accessWidener) {
        this.accessWidener = accessWidener;
    }

    public void read(BufferedReader reader) throws IOException {
        this.read(reader, null);
    }

    public void read(BufferedReader reader, String currentNamespace) throws IOException {
        String line;
        String[] header = reader.readLine().split("\\s+");
        if (header.length != 3 || !header[0].equals("accessWidener")) {
            throw new UnsupportedOperationException("Invalid access access widener file");
        }
        if (!header[1].equals("v1")) {
            throw new RuntimeException(String.format("Unsupported access widener format (%s)", header[1]));
        }
        if (currentNamespace != null && !header[2].equals(currentNamespace)) {
            throw new RuntimeException(String.format("Namespace (%s) does not match current runtime namespace (%s)", header[2], currentNamespace));
        }
        if (this.accessWidener.namespace != null && !this.accessWidener.namespace.equals(header[2])) {
            throw new RuntimeException(String.format("Namespace mismatch, expected %s got %s", this.accessWidener.namespace, header[2]));
        }
        this.accessWidener.namespace = header[2];
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        block10: while ((line = reader.readLine()) != null) {
            int commentPos = line.indexOf(35);
            if (commentPos >= 0) {
                line = line.substring(0, commentPos).trim();
            }
            if (line.isEmpty()) continue;
            String[] split = line.split("\\s+");
            if (split.length != 3 && split.length != 5) {
                throw new RuntimeException(String.format("Invalid line (%s)", line));
            }
            String access = split[0];
            targets.add(split[2].replaceAll("/", "."));
            switch (split[1]) {
                case "class": {
                    if (split.length != 3) {
                        throw new RuntimeException(String.format("Expected (<access>\tclass\t<className>) got (%s)", line));
                    }
                    this.accessWidener.classAccess.put(split[2], this.accessWidener.applyAccess(access, this.accessWidener.classAccess.getOrDefault(split[2], AccessWidener.ClassAccess.DEFAULT), null));
                    continue block10;
                }
                case "field": {
                    if (split.length != 5) {
                        throw new RuntimeException(String.format("Expected (<access>\tfield\t<className>\t<fieldName>\t<fieldDesc>) got (%s)", line));
                    }
                    this.accessWidener.addOrMerge(this.accessWidener.fieldAccess, new EntryTriple(split[2], split[3], split[4]), access, AccessWidener.FieldAccess.DEFAULT);
                    continue block10;
                }
                case "method": {
                    if (split.length != 5) {
                        throw new RuntimeException(String.format("Expected (<access>\tmethod\t<className>\t<methodName>\t<methodDesc>) got (%s)", line));
                    }
                    this.accessWidener.addOrMerge(this.accessWidener.methodAccess, new EntryTriple(split[2], split[3], split[4]), access, AccessWidener.MethodAccess.DEFAULT);
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Unsupported type " + split[1]);
        }
        LinkedHashSet<String> parentClasses = new LinkedHashSet<String>();
        for (String clazz : targets) {
            while (clazz.contains("$")) {
                clazz = clazz.substring(0, clazz.lastIndexOf("$"));
                parentClasses.add(clazz);
            }
        }
        this.accessWidener.classes.addAll(targets);
        this.accessWidener.classes.addAll(parentClasses);
    }
}

