/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.libs.accesswidener;

import java.util.Map;
import org.objectweb.asm.commons.Remapper;
import org.spongepowered.forge.libs.accesswidener.AccessWidener;
import org.spongepowered.forge.libs.accesswidener.EntryTriple;

public final class AccessWidenerRemapper {
    private final AccessWidener input;
    private final String to;
    private final Remapper remapper;

    public AccessWidenerRemapper(AccessWidener input, Remapper remapper, String to) {
        this.input = input;
        this.to = to;
        this.remapper = remapper;
    }

    public AccessWidener remap() {
        if (this.input.namespace.equals(this.to)) {
            return this.input;
        }
        AccessWidener remapped = new AccessWidener();
        remapped.namespace = this.to;
        for (Map.Entry<String, AccessWidener.Access> entry : this.input.classAccess.entrySet()) {
            remapped.classAccess.put(this.remapper.map(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Object, AccessWidener.Access> entry : this.input.methodAccess.entrySet()) {
            remapped.addOrMerge(remapped.methodAccess, this.remapMethod((EntryTriple)entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Object, AccessWidener.Access> entry : this.input.fieldAccess.entrySet()) {
            remapped.addOrMerge(remapped.fieldAccess, this.remapField((EntryTriple)entry.getKey()), entry.getValue());
        }
        return remapped;
    }

    private EntryTriple remapMethod(EntryTriple entryTriple) {
        return new EntryTriple(this.remapper.map(entryTriple.getOwner()), this.remapper.mapMethodName(entryTriple.getOwner(), entryTriple.getName(), entryTriple.getDesc()), this.remapper.mapDesc(entryTriple.getDesc()));
    }

    private EntryTriple remapField(EntryTriple entryTriple) {
        return new EntryTriple(this.remapper.map(entryTriple.getOwner()), this.remapper.mapFieldName(entryTriple.getOwner(), entryTriple.getName(), entryTriple.getDesc()), this.remapper.mapDesc(entryTriple.getDesc()));
    }
}

