/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.libs.accesswidener;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spongepowered.forge.libs.accesswidener.AccessWidener;
import org.spongepowered.forge.libs.accesswidener.EntryTriple;

public final class AccessWidenerWriter {
    private final AccessWidener accessWidener;

    public AccessWidenerWriter(AccessWidener accessWidener) {
        this.accessWidener = accessWidener;
    }

    public void write(StringWriter writer) {
        writer.write("accessWidener\tv1\t");
        writer.write(this.accessWidener.namespace);
        writer.write("\n");
        for (Map.Entry<String, AccessWidener.Access> entry : this.accessWidener.classAccess.entrySet()) {
            for (String s2 : this.getAccesses(entry.getValue())) {
                writer.write(s2);
                writer.write("\tclass\t");
                writer.write(entry.getKey());
                writer.write("\n");
            }
        }
        for (Map.Entry<Object, AccessWidener.Access> entry : this.accessWidener.methodAccess.entrySet()) {
            this.writeEntry(writer, "method", (EntryTriple)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, AccessWidener.Access> entry : this.accessWidener.fieldAccess.entrySet()) {
            this.writeEntry(writer, "field", (EntryTriple)entry.getKey(), entry.getValue());
        }
    }

    private void writeEntry(StringWriter writer, String type, EntryTriple entryTriple, AccessWidener.Access access) {
        for (String s2 : this.getAccesses(access)) {
            writer.write(s2);
            writer.write("\t");
            writer.write(type);
            writer.write("\t");
            writer.write(entryTriple.getOwner());
            writer.write("\t");
            writer.write(entryTriple.getName());
            writer.write("\t");
            writer.write(entryTriple.getDesc());
            writer.write("\n");
        }
    }

    private List<String> getAccesses(AccessWidener.Access access) {
        ArrayList<String> accesses = new ArrayList<String>();
        if (access == AccessWidener.ClassAccess.ACCESSIBLE || access == AccessWidener.MethodAccess.ACCESSIBLE || access == AccessWidener.FieldAccess.ACCESSIBLE || access == AccessWidener.MethodAccess.ACCESSIBLE_EXTENDABLE || access == AccessWidener.ClassAccess.ACCESSIBLE_EXTENDABLE || access == AccessWidener.FieldAccess.ACCESSIBLE_MUTABLE) {
            accesses.add("accessible");
        }
        if (access == AccessWidener.ClassAccess.EXTENDABLE || access == AccessWidener.MethodAccess.EXTENDABLE || access == AccessWidener.MethodAccess.ACCESSIBLE_EXTENDABLE || access == AccessWidener.ClassAccess.ACCESSIBLE_EXTENDABLE) {
            accesses.add("extendable");
        }
        if (access == AccessWidener.FieldAccess.MUTABLE || access == AccessWidener.FieldAccess.ACCESSIBLE_MUTABLE) {
            accesses.add("mutable");
        }
        return accesses;
    }
}

