/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.mixin.core.minecraftforge.core;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.core.RegistryBridge;
import org.spongepowered.common.registry.SpongeRegistryEntry;
import org.spongepowered.common.registry.SpongeRegistryType;
import org.spongepowered.forge.bridge.minecraftforge.fml.ForgeRegistryBridge;

@Mixin(value={ForgeRegistry.class})
public abstract class ForgeRegistryMixin_Forge<V extends IForgeRegistryEntry<V>>
implements ForgeRegistryBridge<V> {
    @Shadow
    @Final
    private RegistryKey<Registry<V>> key;
    private final Map<ResourceKey, RegistryBridge<V>> forge$parents = Maps.newHashMap();
    private boolean forge$warnedIfNoParent;

    @Inject(method={"add(ILnet/minecraftforge/registries/IForgeRegistryEntry;Ljava/lang/String;)I"}, at={@At(value="TAIL")})
    public void forge$writeToParent(int id, V value, String owner, CallbackInfoReturnable<Integer> cir) {
        ResourceKey root = (ResourceKey)this.key.getRegistryName();
        ResourceKey location = (ResourceKey)this.key.func_240901_a_();
        if (!this.forge$warnedIfNoParent && this.forge$parents.isEmpty()) {
            if (location.namespace().equalsIgnoreCase("minecraft")) {
                SpongeCommon.logger().error(String.format("No parent registry found for %s, things might not work correctly!", new StringJoiner("/").add(root.formatted()).add(location.formatted())));
            }
            this.forge$warnedIfNoParent = true;
        }
        SpongeRegistryEntry entry = new SpongeRegistryEntry(new SpongeRegistryType(root, location), (ResourceKey)value.getRegistryName(), value);
        this.forge$parents.values().forEach(registry -> registry.bridge$register(entry));
    }

    @Inject(method={"setSlaveMap(Lnet/minecraft/util/ResourceLocation;Ljava/lang/Object;)V"}, at={@At(value="TAIL")})
    public void forge$establishParent(ResourceLocation name, Object obj, CallbackInfo ci) {
        if (obj instanceof RegistryBridge) {
            this.forge$parents.put((ResourceKey)name, (RegistryBridge)obj);
        }
    }
}

