/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.mixin.core.minecraftforge.event.world;

import java.util.Collections;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.BlockEvent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.transaction.BlockTransaction;
import org.spongepowered.api.block.transaction.Operations;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.forge.launch.bridge.event.ForgeEventBridge_Forge;
import org.spongepowered.forge.mixin.core.minecraftforge.event.world.BlockEventMixin_Forge;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={BlockEvent.BreakEvent.class}, remap=false)
public abstract class BlockEvent_BreakEventMixin_Forge
extends BlockEventMixin_Forge
implements ForgeEventBridge_Forge {
    @Override
    public void bridge$syncFrom(Event event) {
        if (event instanceof ChangeBlockEvent.All) {
            ChangeBlockEvent.All changeBlockEventAll = (ChangeBlockEvent.All)event;
            Vector3i pos = VecHelper.toVector3i(this.shadow$getPos());
            if (changeBlockEventAll.isCancelled() || changeBlockEventAll.transactions().stream().filter(x -> ((BlockSnapshot)x.original()).position().equals((Object)pos)).anyMatch(x -> !x.isValid() || x.operation() != Operations.BREAK.get() || x.custom().isPresent())) {
                ((net.minecraftforge.eventbus.api.Event)this).setCanceled(true);
            }
        }
    }

    @Override
    public void bridge$syncTo(Event event) {
        if (event instanceof ChangeBlockEvent.All && ((net.minecraftforge.eventbus.api.Event)this).isCanceled()) {
            Vector3i pos = VecHelper.toVector3i(this.shadow$getPos());
            ((ChangeBlockEvent.All)event).transactions(Operations.BREAK.get()).filter(x -> ((BlockSnapshot)x.original()).position().equals((Object)pos)).forEach(x -> x.setValid(false));
        }
    }

    @Override
    public @Nullable Event bridge$createSpongeEvent() {
        IWorld accessor = this.shadow$getWorld();
        if (accessor instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)accessor;
            BlockTransaction transaction = new BlockTransaction(SpongeBlockSnapshot.BuilderImpl.pooled().world(serverWorld.key()).position(VecHelper.toVector3i(this.shadow$getPos())).blockState((BlockState)this.shadow$getState()).build(), SpongeBlockSnapshot.BuilderImpl.pooled().world(serverWorld.key()).position(VecHelper.toVector3i(this.shadow$getPos())).blockState((BlockState)BlockState.builder().blockType(BlockTypes.AIR.get()).build()).build(), Operations.BREAK.get());
            return SpongeEventFactory.createChangeBlockEventAll(PhaseTracker.getCauseStackManager().currentCause(), Collections.singletonList(transaction), serverWorld);
        }
        return null;
    }
}

