/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.mixin.plugin;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.TransformingClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.mixin.plugin.AbstractMixinConfigPlugin;

public class ForgeCorePlugin
extends AbstractMixinConfigPlugin {
    private static final String[] FORCED_ALLOWED_PACKAGES = new String[]{"com.google.inject.", "javax.inject."};
    private static final Logger LOGGER = LogManager.getLogger();

    public ForgeCorePlugin() {
        try {
            Class.forName("org.spongepowered.forge.applaunch.plugin.ForgePluginPlatform").getMethod("bootstrap", Environment.class).invoke(null, Launcher.INSTANCE.environment());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.error("Failed to bootstrap the Forge plugin platform on TCL", (Throwable)ex);
        }
        try {
            TransformingClassLoader tcl = (TransformingClassLoader)this.getClass().getClassLoader();
            Field targetPackageFilter = tcl.getClass().getDeclaredField("targetPackageFilter");
            targetPackageFilter.setAccessible(true);
            Predicate existing = (Predicate)targetPackageFilter.get(tcl);
            Predicate<String> better = pkg -> {
                for (String prefix : FORCED_ALLOWED_PACKAGES) {
                    if (!pkg.startsWith(prefix)) continue;
                    return true;
                }
                return existing.test(pkg);
            };
            targetPackageFilter.set(tcl, better);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Failed to fix TCL package filter", (Throwable)ex);
        }
    }
}

