/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.Container;
import org.spongepowered.plugin.metadata.Inheritable;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.StandardInheritable;
import org.spongepowered.plugin.metadata.builtin.StandardPluginMetadata;
import org.spongepowered.plugin.metadata.builtin.model.Adapters;
import org.spongepowered.plugin.metadata.builtin.model.StandardContainerLoader;
import org.spongepowered.plugin.metadata.util.GsonUtils;

public final class MetadataContainer
implements Container {
    private final String license;
    private final @Nullable String mappings;
    private final StandardContainerLoader loader;
    private final @Nullable Inheritable globalMetadata;
    private final Set<StandardPluginMetadata> metadata = new LinkedHashSet<StandardPluginMetadata>();
    private final Map<String, StandardPluginMetadata> metadataById = new LinkedHashMap<String, StandardPluginMetadata>();

    private MetadataContainer(Builder builder) {
        this.loader = builder.loader;
        this.license = builder.license;
        this.mappings = builder.mappings;
        this.globalMetadata = builder.globalMetadata;
        this.metadata.addAll(builder.metadata);
        for (StandardPluginMetadata pm : this.metadata) {
            this.metadataById.put(pm.id(), pm);
            pm.setContainer(this);
        }
    }

    @Override
    public StandardContainerLoader loader() {
        return this.loader;
    }

    @Override
    public String license() {
        return this.license;
    }

    @Override
    public Optional<String> mappings() {
        return Optional.ofNullable(this.mappings);
    }

    @Override
    public Optional<Inheritable> globalMetadata() {
        return Optional.ofNullable(this.globalMetadata);
    }

    @Override
    public Optional<PluginMetadata> metadata(String id) {
        return Optional.ofNullable((PluginMetadata)this.metadataById.get(Objects.requireNonNull(id, "id")));
    }

    @Override
    public Set<PluginMetadata> metadata() {
        return Collections.unmodifiableSet(this.metadata);
    }

    public String toString() {
        return new StringJoiner(", ", MetadataContainer.class.getSimpleName() + "[", "]").add("loader=" + this.loader).add("license=" + this.license).add("mappings=" + this.mappings).add("globalMetadata=" + this.globalMetadata).toString();
    }

    public static final class Serializer
    implements JsonSerializer<MetadataContainer>,
    JsonDeserializer<MetadataContainer> {
        @Override
        public MetadataContainer deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = element.getAsJsonObject();
            Builder builder = new Builder().loader(Adapters.Deserializers.CONTAINER_LOADER.fromJsonTree(obj.get("loader")).build()).license(obj.get("license").getAsString());
            GsonUtils.consumeIfPresent(obj, "mappings", e -> builder.mappings(e.getAsString()));
            JsonElement globalElement = obj.get("global");
            StandardInheritable inheritable = null;
            if (globalElement instanceof JsonObject) {
                inheritable = (StandardInheritable)context.deserialize(globalElement, (Type)((Object)StandardInheritable.class));
                builder.globalMetadata(inheritable);
            }
            JsonElement pluginsElement = obj.get("plugins");
            LinkedList<JsonObject> pluginObjects = new LinkedList<JsonObject>();
            if (pluginsElement.isJsonArray()) {
                for (JsonElement pluginElement : (JsonArray)pluginsElement) {
                    if (!pluginElement.isJsonObject()) continue;
                    pluginObjects.add((JsonObject)pluginElement);
                }
            }
            if (pluginObjects.isEmpty()) {
                throw new JsonParseException("No plugin metadata has been specified for the 'plugins' tag!");
            }
            for (JsonObject pluginObject : pluginObjects) {
                StandardPluginMetadata.Builder pluginBuilder = (StandardPluginMetadata.Builder)context.deserialize(pluginObject, (Type)((Object)StandardPluginMetadata.Builder.class));
                if (inheritable != null) {
                    pluginBuilder.from(inheritable);
                }
                builder.addMetadata((StandardPluginMetadata)pluginBuilder.build());
            }
            try {
                return builder.build();
            }
            catch (InvalidVersionSpecificationException e2) {
                throw new JsonParseException(e2);
            }
        }

        @Override
        public JsonElement serialize(MetadataContainer value, Type type, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("loader", Adapters.Serializers.CONTAINER_LOADER.toJsonTree(value.loader));
            obj.addProperty("license", value.license);
            GsonUtils.writeIfPresent(obj, "mappings", value.mappings());
            JsonArray plugins = new JsonArray();
            for (PluginMetadata metadata : value.metadata) {
                plugins.add(context.serialize(metadata, (Type)((Object)StandardPluginMetadata.class)));
            }
            obj.add("plugins", plugins);
            return obj;
        }
    }

    public static final class Builder {
        final Set<StandardPluginMetadata> metadata = new LinkedHashSet<StandardPluginMetadata>();
        @Nullable String license;
        @Nullable String mappings;
        @Nullable StandardContainerLoader loader;
        @Nullable Inheritable globalMetadata;

        public Builder loader(StandardContainerLoader loader) {
            this.loader = Objects.requireNonNull(loader, "loader");
            return this;
        }

        public Builder license(String license) {
            this.license = Objects.requireNonNull(license, "license");
            return this;
        }

        public Builder mappings(@Nullable String mappings) {
            if (mappings != null) {
                String[] elements = mappings.split("\\.", 3);
                ArtifactUtils.key(elements[0], elements[1], elements[2]);
            }
            this.mappings = mappings;
            return this;
        }

        public Builder globalMetadata(Inheritable globalMetadata) {
            this.globalMetadata = Objects.requireNonNull(globalMetadata, "globalMetadata");
            return this;
        }

        public Builder metadata(List<StandardPluginMetadata> metadata) {
            this.metadata.addAll((Collection<StandardPluginMetadata>)Objects.requireNonNull(metadata, "metadata"));
            return this;
        }

        public Builder addMetadata(StandardPluginMetadata metadata) {
            this.metadata.add(Objects.requireNonNull(metadata, "metadata"));
            return this;
        }

        public MetadataContainer build() throws IllegalStateException, InvalidVersionSpecificationException {
            Objects.requireNonNull(this.license, "license");
            Objects.requireNonNull(this.loader, "loader");
            if (this.metadata.isEmpty()) {
                throw new IllegalStateException("A MetadataHolder must hold at least 1 PluginMetadata!");
            }
            return new MetadataContainer(this);
        }
    }
}

