/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.spongepowered.plugin.metadata.builtin.MetadataContainer;
import org.spongepowered.plugin.metadata.builtin.StandardInheritable;
import org.spongepowered.plugin.metadata.builtin.StandardPluginMetadata;

public final class MetadataParser {
    private MetadataParser() {
    }

    public static GsonBuilder gsonBuilder() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)MetadataContainer.class), new MetadataContainer.Serializer()).registerTypeAdapter((Type)((Object)StandardInheritable.class), new StandardInheritable.Serializer()).registerTypeAdapter((Type)((Object)StandardPluginMetadata.Builder.class), new StandardPluginMetadata.Deserializer()).registerTypeAdapter((Type)((Object)StandardPluginMetadata.class), new StandardPluginMetadata.Serializer());
    }

    public static MetadataContainer read(Path path) throws IOException {
        return MetadataParser.read(path, MetadataParser.gsonBuilder().create());
    }

    public static MetadataContainer read(Path path, Gson gson) throws IOException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(gson, "gson");
        try (BufferedReader reader = Files.newBufferedReader(path);){
            MetadataContainer metadataContainer = gson.fromJson((Reader)reader, MetadataContainer.class);
            return metadataContainer;
        }
    }

    public static MetadataContainer read(Reader reader) throws IOException {
        return MetadataParser.read(reader, MetadataParser.gsonBuilder().create());
    }

    public static MetadataContainer read(Reader reader, Gson gson) throws IOException {
        Objects.requireNonNull(reader, "reader");
        Objects.requireNonNull(gson, "gson");
        try (JsonReader jsonReader = new JsonReader(reader);){
            MetadataContainer metadataContainer = (MetadataContainer)gson.fromJson(jsonReader, (Type)((Object)MetadataContainer.class));
            return metadataContainer;
        }
    }

    public static void write(Path path, MetadataContainer container, Gson gson, boolean indent) throws IOException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(container, "container");
        Objects.requireNonNull(gson, "gson");
        try (JsonWriter writer = new JsonWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            if (indent) {
                writer.setIndent("  ");
            }
            gson.toJson((Object)container, (Type)((Object)MetadataContainer.class), writer);
        }
    }

    public static void write(Writer writer, MetadataContainer container, Gson gson, boolean indent) throws IOException {
        Objects.requireNonNull(writer, "writer");
        Objects.requireNonNull(container, "container");
        Objects.requireNonNull(gson, "gson");
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            if (indent) {
                jsonWriter.setIndent("  ");
            }
            gson.toJson((Object)container, (Type)((Object)MetadataContainer.class), jsonWriter);
        }
    }
}

