/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.Constants;
import org.spongepowered.plugin.metadata.Container;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.MetadataContainer;
import org.spongepowered.plugin.metadata.builtin.NullVersion;
import org.spongepowered.plugin.metadata.builtin.StandardInheritable;
import org.spongepowered.plugin.metadata.util.GsonUtils;

public final class StandardPluginMetadata
extends StandardInheritable
implements PluginMetadata {
    private final String id;
    private final String entrypoint;
    private final @Nullable String name;
    private final @Nullable String description;
    private @Nullable Container container;

    private StandardPluginMetadata(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.entrypoint = builder.entrypoint;
        this.name = builder.name;
        this.description = builder.description;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Container container() {
        return this.container;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String entrypoint() {
        return this.entrypoint;
    }

    @Override
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    void setContainer(MetadataContainer container) {
        this.container = container;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardPluginMetadata)) {
            return false;
        }
        StandardPluginMetadata other = (StandardPluginMetadata)o;
        return this.id.equals(other.id);
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", StandardPluginMetadata.class.getSimpleName() + "[", "]").add("id=" + this.id).add("name=" + this.name).add("entrypoint=" + this.entrypoint).add("description=" + this.description);
        joiner.merge(this.stringJoiner());
        return joiner.toString();
    }

    public static final class Serializer
    implements JsonSerializer<StandardPluginMetadata> {
        @Override
        public JsonElement serialize(StandardPluginMetadata value, Type type, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("id", value.id);
            obj.addProperty("entrypoint", value.entrypoint);
            GsonUtils.writeIfPresent(obj, "name", value.name());
            GsonUtils.writeIfPresent(obj, "description", value.description());
            JsonObject inheritableElement = (JsonObject)context.serialize(value, (Type)((Object)StandardInheritable.class));
            for (Map.Entry<String, JsonElement> entry : inheritableElement.entrySet()) {
                obj.add(entry.getKey(), entry.getValue());
            }
            return obj;
        }
    }

    public static final class Deserializer
    implements JsonDeserializer<Builder> {
        @Override
        public Builder deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = element.getAsJsonObject();
            Builder builder = new Builder();
            builder.id(obj.get("id").getAsString()).entrypoint(obj.get("entrypoint").getAsString());
            GsonUtils.consumeIfPresent(obj, "name", e -> builder.name(e.getAsString()));
            GsonUtils.consumeIfPresent(obj, "description", e -> builder.description(e.getAsString()));
            builder.from((StandardInheritable)context.deserialize(element, (Type)((Object)StandardInheritable.class)));
            return builder;
        }
    }

    public static final class Builder
    extends StandardInheritable.AbstractBuilder<StandardPluginMetadata, Builder> {
        @Nullable String id;
        @Nullable String entrypoint;
        @Nullable String name;
        @Nullable String description;

        public Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        public Builder entrypoint(String entrypoint) {
            this.entrypoint = Objects.requireNonNull(entrypoint, "entrypoint");
            return this;
        }

        public Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @Override
        protected StandardPluginMetadata build0() {
            if (!Constants.VALID_ID_PATTERN.matcher(Objects.requireNonNull(this.id, "id")).matches()) {
                throw new IllegalStateException(String.format("PluginMetadata with supplied ID '{%s}' is invalid. %s", this.id, "IDs can be between 2 and 64 characters long and must start with a lower case letter, followed by any mix of lower case letters (a-z), numbers (0-9), dashes (-) and underscores (_)."));
            }
            if (this.version == NullVersion.instance()) {
                throw new IllegalStateException(String.format("PluginMetadata with supplied ID '{%s}' has no version specified.", this.id));
            }
            Objects.requireNonNull(this.entrypoint, "entrypoint");
            return new StandardPluginMetadata(this);
        }
    }
}

