/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin.model;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.maven.artifact.versioning.VersionRange;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.model.ContainerLoader;

public final class StandardContainerLoader
implements ContainerLoader {
    private final String name;
    private final String rawVersion;
    private final VersionRange version;

    private StandardContainerLoader(Builder builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.rawVersion = builder.rawVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public VersionRange version() {
        return this.version;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.name = this.name;
        builder.version = this.version;
        builder.rawVersion = this.rawVersion;
        return builder;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardContainerLoader)) {
            return false;
        }
        StandardContainerLoader that = (StandardContainerLoader)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        return new StringJoiner(", ", StandardContainerLoader.class.getSimpleName() + "[", "]").add("name=" + this.name).add("version=" + this.rawVersion).toString();
    }

    public static final class Serializer
    extends TypeAdapter<StandardContainerLoader> {
        @Override
        public void write(JsonWriter out, StandardContainerLoader value) throws IOException {
            Objects.requireNonNull(out, "out");
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("name").value(value.name);
            out.name("version").value(value.rawVersion);
            out.endObject();
        }

        @Override
        public StandardContainerLoader read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("This adapter is for writing only");
        }
    }

    public static final class Deserializer
    extends TypeAdapter<Builder> {
        @Override
        public void write(JsonWriter out, Builder builder) throws IOException {
            throw new UnsupportedOperationException("This adapter is for reading only");
        }

        @Override
        public Builder read(JsonReader in) throws IOException {
            Objects.requireNonNull(in, "in");
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            HashSet<String> processedKeys = new HashSet<String>();
            Builder builder = StandardContainerLoader.builder();
            while (in.hasNext()) {
                String key = in.nextName();
                if (!processedKeys.add(key)) {
                    throw new JsonParseException(String.format("Duplicate id key '%s' in %s", key, in));
                }
                switch (key) {
                    case "name": {
                        builder.name(in.nextString());
                        break;
                    }
                    case "version": {
                        builder.version(in.nextString());
                    }
                }
            }
            in.endObject();
            return builder;
        }
    }

    public static final class Builder {
        @Nullable String name;
        @Nullable String rawVersion;
        @Nullable VersionRange version;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = VersionRange.createFromVersion(Objects.requireNonNull(version, "version"));
            this.rawVersion = version;
            return this;
        }

        public StandardContainerLoader build() {
            Objects.requireNonNull(this.name, "name");
            Objects.requireNonNull(this.version, "version");
            return new StandardContainerLoader(this);
        }
    }
}

