/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin.model;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.model.PluginBranding;
import org.spongepowered.plugin.metadata.util.GsonUtils;

public final class StandardPluginBranding
implements PluginBranding {
    private static final StandardPluginBranding NONE = new StandardPluginBranding();
    private final @Nullable String logo;
    private final @Nullable String icon;

    private StandardPluginBranding(Builder builder) {
        this.logo = builder.logo;
        this.icon = builder.icon;
    }

    private StandardPluginBranding() {
        this.logo = null;
        this.icon = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StandardPluginBranding none() {
        return NONE;
    }

    @Override
    public Optional<String> logo() {
        return Optional.ofNullable(this.logo);
    }

    @Override
    public Optional<String> icon() {
        return Optional.ofNullable(this.icon);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.logo = this.logo;
        builder.icon = this.icon;
        return builder;
    }

    public String toString() {
        return new StringJoiner(", ", StandardPluginBranding.class.getSimpleName() + "[", "]").add("logo=" + this.logo).add("icon=" + this.icon).toString();
    }

    public static final class Serializer
    extends TypeAdapter<StandardPluginBranding> {
        @Override
        public void write(JsonWriter out, StandardPluginBranding value) throws IOException {
            Objects.requireNonNull(out, "out");
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            GsonUtils.writeIfPresent(out, "logo", value.logo());
            GsonUtils.writeIfPresent(out, "icon", value.icon());
            out.endObject();
        }

        @Override
        public StandardPluginBranding read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("This adapter is for writing only");
        }
    }

    public static final class Deserializer
    extends TypeAdapter<Builder> {
        @Override
        public void write(JsonWriter out, Builder builder) throws IOException {
            throw new UnsupportedOperationException("This adapter is for reading only");
        }

        @Override
        public Builder read(JsonReader in) throws IOException {
            Objects.requireNonNull(in, "in");
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            HashSet<String> processedKeys = new HashSet<String>();
            Builder builder = StandardPluginBranding.builder();
            while (in.hasNext()) {
                String key = in.nextName();
                if (!processedKeys.add(key)) {
                    throw new JsonParseException(String.format("Duplicate branding key '%s' in %s", key, in));
                }
                switch (key) {
                    case "logo": {
                        builder.logo(in.nextString());
                        break;
                    }
                    case "icon": {
                        builder.icon(in.nextString());
                    }
                }
            }
            in.endObject();
            return builder;
        }
    }

    public static final class Builder {
        @Nullable String logo;
        @Nullable String icon;

        private Builder() {
        }

        public Builder logo(@Nullable String logo) {
            this.logo = logo;
            return this;
        }

        public Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        public StandardPluginBranding build() {
            return new StandardPluginBranding(this);
        }
    }
}

