/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin.model;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.model.PluginContributor;
import org.spongepowered.plugin.metadata.util.GsonUtils;

public final class StandardPluginContributor
implements PluginContributor {
    private final String name;
    private final @Nullable String description;

    private StandardPluginContributor(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.name = this.name;
        builder.description = this.description;
        return builder;
    }

    public String toString() {
        return new StringJoiner(", ", StandardPluginContributor.class.getSimpleName() + "[", "]").add("name=" + this.name).add("description=" + this.description).toString();
    }

    public static final class Serializer
    extends TypeAdapter<StandardPluginContributor> {
        @Override
        public void write(JsonWriter out, StandardPluginContributor value) throws IOException {
            Objects.requireNonNull(out, "out");
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("name").value(value.name());
            GsonUtils.writeIfPresent(out, "description", value.description());
            out.endObject();
        }

        @Override
        public StandardPluginContributor read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("This adapter is for writing only");
        }
    }

    public static final class Deserializer
    extends TypeAdapter<Builder> {
        @Override
        public void write(JsonWriter out, Builder builder) throws IOException {
            throw new UnsupportedOperationException("This adapter is for reading only");
        }

        @Override
        public Builder read(JsonReader in) throws IOException {
            Objects.requireNonNull(in, "in");
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            HashSet<String> processedKeys = new HashSet<String>();
            Builder builder = StandardPluginContributor.builder();
            while (in.hasNext()) {
                String key = in.nextName();
                if (!processedKeys.add(key)) {
                    throw new JsonParseException(String.format("Duplicate contributor key '%s' in %s", key, in));
                }
                switch (key) {
                    case "name": {
                        builder.name(in.nextString());
                        break;
                    }
                    case "description": {
                        builder.description(in.nextString());
                    }
                }
            }
            in.endObject();
            return builder;
        }
    }

    public static final class Builder {
        @Nullable String name;
        @Nullable String description;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public StandardPluginContributor build() {
            Objects.requireNonNull(this.name, "name");
            return new StandardPluginContributor(this);
        }
    }
}

