/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.metadata.builtin.model;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.maven.artifact.versioning.VersionRange;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.plugin.metadata.Constants;
import org.spongepowered.plugin.metadata.model.PluginDependency;

public final class StandardPluginDependency
implements PluginDependency {
    private final String id;
    private final VersionRange version;
    private final String rawVersion;
    private final PluginDependency.LoadOrder loadOrder;
    private final boolean optional;

    private StandardPluginDependency(Builder builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.rawVersion = builder.rawVersion;
        this.loadOrder = builder.loadOrder;
        this.optional = builder.optional;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public VersionRange version() {
        return this.version;
    }

    @Override
    public PluginDependency.LoadOrder loadOrder() {
        return this.loadOrder;
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id = this.id;
        builder.version = this.version;
        builder.rawVersion = this.rawVersion;
        builder.loadOrder = this.loadOrder;
        builder.optional = this.optional;
        return builder;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardPluginDependency)) {
            return false;
        }
        StandardPluginDependency that = (StandardPluginDependency)o;
        return this.id.equals(that.id);
    }

    public String toString() {
        return new StringJoiner(", ", StandardPluginDependency.class.getSimpleName() + "[", "]").add("id=" + this.id).add("version=" + this.rawVersion).add("loadOrder=" + (Object)((Object)this.loadOrder)).add("optional=" + this.optional).toString();
    }

    public static final class Serializer
    extends TypeAdapter<StandardPluginDependency> {
        @Override
        public void write(JsonWriter out, StandardPluginDependency value) throws IOException {
            Objects.requireNonNull(out, "out");
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("id").value(value.id());
            out.name("version").value(value.rawVersion);
            out.name("load-order").value(value.loadOrder().name().toLowerCase(Locale.ROOT));
            out.name("optional").value(value.optional());
            out.endObject();
        }

        @Override
        public StandardPluginDependency read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("This adapter is for writing only");
        }
    }

    public static final class Deserializer
    extends TypeAdapter<Builder> {
        @Override
        public void write(JsonWriter out, Builder builder) throws IOException {
            throw new UnsupportedOperationException("This adapter is for reading only");
        }

        @Override
        public Builder read(JsonReader in) throws IOException {
            Objects.requireNonNull(in, "in");
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            HashSet<String> processedKeys = new HashSet<String>();
            Builder builder = StandardPluginDependency.builder();
            while (in.hasNext()) {
                String key = in.nextName();
                if (!processedKeys.add(key)) {
                    throw new JsonParseException(String.format("Duplicate dependency key '%s' in %s", key, in));
                }
                switch (key) {
                    case "id": {
                        builder.id(in.nextString());
                        break;
                    }
                    case "version": {
                        builder.version(in.nextString());
                        break;
                    }
                    case "optional": {
                        builder.optional(in.nextBoolean());
                        break;
                    }
                    case "load-order": {
                        try {
                            builder.loadOrder(PluginDependency.LoadOrder.valueOf(in.nextString().toUpperCase()));
                            break;
                        }
                        catch (Exception ex) {
                            throw new JsonParseException(String.format("Invalid load order found in '%s'", in), ex);
                        }
                    }
                }
            }
            in.endObject();
            return builder;
        }
    }

    public static final class Builder {
        @Nullable String id;
        @Nullable VersionRange version;
        @Nullable String rawVersion;
        PluginDependency.LoadOrder loadOrder = PluginDependency.LoadOrder.UNDEFINED;
        boolean optional = false;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        public Builder version(String version) {
            this.version = VersionRange.createFromVersion(Objects.requireNonNull(version, "version"));
            this.rawVersion = version;
            return this;
        }

        public Builder loadOrder(PluginDependency.LoadOrder loadOrder) {
            this.loadOrder = Objects.requireNonNull(loadOrder, "load order");
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public StandardPluginDependency build() {
            Objects.requireNonNull(this.id, "id");
            if (!Constants.VALID_ID_PATTERN.matcher(this.id).matches()) {
                throw new IllegalStateException(String.format("Dependency with supplied ID '{%s}' is invalid. %s", this.id, "IDs can be between 2 and 64 characters long and must start with a lower case letter, followed by any mix of lower case letters (a-z), numbers (0-9), dashes (-) and underscores (_)."));
            }
            Objects.requireNonNull(this.version, "version");
            return new StandardPluginDependency(this);
        }
    }
}

