/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.cadixdev.bombe.analysis.InheritanceProvider;

public class CascadingInheritanceProvider
implements InheritanceProvider {
    private final ArrayList<InheritanceProvider> providers;

    public CascadingInheritanceProvider(List<InheritanceProvider> providers) {
        this.providers = new ArrayList<InheritanceProvider>(providers);
    }

    public CascadingInheritanceProvider() {
        this.providers = new ArrayList();
    }

    public CascadingInheritanceProvider install(InheritanceProvider provider) {
        this.providers.add(provider);
        return this;
    }

    @Override
    public Optional<InheritanceProvider.ClassInfo> provide(String klass) {
        for (InheritanceProvider provider : this.providers) {
            Optional<InheritanceProvider.ClassInfo> info = provider.provide(klass);
            if (!info.isPresent()) continue;
            return info;
        }
        return Optional.empty();
    }

    @Override
    public Optional<InheritanceProvider.ClassInfo> provide(String klass, Object context) {
        for (InheritanceProvider provider : this.providers) {
            Optional<InheritanceProvider.ClassInfo> info = provider.provide(klass, context);
            if (!info.isPresent()) continue;
            return info;
        }
        return Optional.empty();
    }
}

