/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.cadixdev.bombe.jar.AbstractJarEntry;
import org.cadixdev.bombe.jar.JarEntryTransformer;
import org.cadixdev.bombe.jar.ServiceProviderConfiguration;

public class JarServiceProviderConfigurationEntry
extends AbstractJarEntry {
    private final ServiceProviderConfiguration config;
    private String extension;

    public JarServiceProviderConfigurationEntry(long time, ServiceProviderConfiguration config) {
        super("META-INF/services/" + config.getService(), time);
        this.config = config;
    }

    public final ServiceProviderConfiguration getConfig() {
        return this.config;
    }

    @Override
    public final String getExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        int index = this.name.lastIndexOf(46);
        if (index == -1) {
            this.extension = "";
            return "";
        }
        this.extension = this.name.substring(index + 1);
        return this.extension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final byte[] getContents() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.config.write(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Override
    public final JarServiceProviderConfigurationEntry accept(JarEntryTransformer vistor) {
        return vistor.transform(this);
    }
}

