/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.MappingsReader;
import org.cadixdev.lorenz.io.MappingsWriter;

public interface MappingFormat {
    public MappingsReader createReader(InputStream var1) throws IOException;

    default public MappingsReader createReader(Path path) throws IOException {
        return this.createReader(Files.newInputStream(path, new OpenOption[0]));
    }

    default public MappingSet read(MappingSet mappings, Path path) throws IOException {
        try (MappingsReader reader = this.createReader(path);){
            reader.read(mappings);
        }
        return mappings;
    }

    default public MappingSet read(Path path) throws IOException {
        return this.read(MappingSet.create(), path);
    }

    public MappingsWriter createWriter(OutputStream var1) throws IOException;

    default public MappingsWriter createWriter(Path path) throws IOException {
        return this.createWriter(Files.newOutputStream(path, new OpenOption[0]));
    }

    default public void write(MappingSet mappings, Path path) throws IOException {
        try (MappingsWriter writer = this.createWriter(path);){
            writer.write(mappings);
        }
    }

    public Optional<String> getStandardFileExtension();
}

