/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.block;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.SerializableDataHolderBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableSnapshot;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.math.vector.Vector3i;

public interface BlockSnapshot
extends LocatableSnapshot<BlockSnapshot> {
    public static final Supplier<BlockSnapshot> NONE = BlockSnapshot::empty;

    public static BlockSnapshot empty() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class).empty();
    }

    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public BlockState getState();

    public BlockSnapshot withState(BlockState var1);

    public BlockSnapshot withContainer(DataContainer var1);

    public boolean restore(boolean var1, BlockChangeFlag var2);

    public Optional<UUID> getCreator();

    public Optional<UUID> getNotifier();

    public Optional<BlockEntityArchetype> createArchetype();

    public static interface Builder
    extends SerializableDataHolderBuilder.Immutable<BlockSnapshot, Builder> {
        public Builder world(WorldProperties var1);

        public Builder blockState(BlockState var1);

        public Builder position(Vector3i var1);

        @Override
        public Builder from(ServerLocation var1);

        public Builder creator(UUID var1);

        public Builder notifier(UUID var1);

        public BlockSnapshot empty();
    }
}

