/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.parameter.managed.standard;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.util.ResettableBuilder;

public final class VariableValueParameters {
    private VariableValueParameters() {
    }

    public static <T extends CatalogType> CatalogedTypeBuilder<T> catalogedElementParameterBuilder(Class<T> returnType) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createCatalogedTypesBuilder(returnType);
    }

    public static <T> StaticChoicesBuilder<T> staticChoicesBuilder(Class<T> returnType) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createStaticChoicesBuilder(returnType);
    }

    public static <T> DynamicChoicesBuilder<T> dynamicChoicesBuilder(Class<T> returnType) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createDynamicChoicesBuilder(returnType);
    }

    public static <T> LiteralBuilder<T> literalBuilder(Class<T> returnType) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createLiteralBuilder(returnType);
    }

    public static TextBuilder textBuilder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(TextBuilder.class);
    }

    public static <T extends Enum<T>> ValueParameter<T> enumChoices(Class<T> enumClass) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createEnumParameter(enumClass);
    }

    public static NumberRangeBuilder<Double> doubleRange() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createDoubleNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Float> floatRange() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createFloatNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Integer> integerRange() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createIntegerNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Long> longRange() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createLongNumberRangeBuilder();
    }

    public static ValueParameter<String> validatedString(Pattern pattern) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).createValidatedStringParameter(pattern);
    }

    public static interface Factory {
        public <T extends Enum<T>> ValueParameter<T> createEnumParameter(Class<T> var1);

        public <T> StaticChoicesBuilder<T> createStaticChoicesBuilder(Class<T> var1);

        public <T> DynamicChoicesBuilder<T> createDynamicChoicesBuilder(Class<T> var1);

        public <T extends CatalogType> CatalogedTypeBuilder<T> createCatalogedTypesBuilder(Class<T> var1);

        public <T> LiteralBuilder<T> createLiteralBuilder(Class<T> var1);

        public NumberRangeBuilder<Integer> createIntegerNumberRangeBuilder();

        public NumberRangeBuilder<Float> createFloatNumberRangeBuilder();

        public NumberRangeBuilder<Double> createDoubleNumberRangeBuilder();

        public NumberRangeBuilder<Long> createLongNumberRangeBuilder();

        public ValueParameter<String> createValidatedStringParameter(Pattern var1);
    }

    public static interface NumberRangeBuilder<T extends Number>
    extends ResettableBuilder<ValueParameter<T>, NumberRangeBuilder<T>> {
        public NumberRangeBuilder<T> setMin(T var1);

        public NumberRangeBuilder<T> setMax(T var1);

        public ValueParameter<T> build();
    }

    public static interface TextBuilder
    extends ResettableBuilder<ValueParameter<Component>, TextBuilder> {
        public TextBuilder setSerializer(ComponentSerializer<Component, ? extends Component, String> var1);

        public TextBuilder setSerializerSupplier(Supplier<ComponentSerializer<Component, ? extends Component, String>> var1);

        public TextBuilder setConsumeAllArguments(boolean var1);

        public ValueParameter<Component> build() throws IllegalStateException;
    }

    public static interface LiteralBuilder<T>
    extends ResettableBuilder<ValueParameter<T>, LiteralBuilder<T>> {
        public LiteralBuilder<T> setLiteral(Supplier<? extends Collection<String>> var1);

        default public LiteralBuilder<T> setLiteral(Collection<String> literal) {
            return this.setLiteral(() -> literal);
        }

        public LiteralBuilder<T> setReturnValue(Supplier<T> var1);

        default public LiteralBuilder<T> setReturnValue(T returnValue) {
            return this.setReturnValue((T)((Supplier<Object>)() -> returnValue));
        }

        public ValueParameter<T> build();
    }

    public static interface DynamicChoicesBuilder<T>
    extends ResettableBuilder<ValueParameter<T>, DynamicChoicesBuilder<T>> {
        public DynamicChoicesBuilder<T> setChoicesAndResults(Supplier<Map<String, ? extends T>> var1);

        public DynamicChoicesBuilder<T> setChoices(Supplier<? extends Collection<String>> var1);

        public DynamicChoicesBuilder<T> setResults(Function<String, ? extends T> var1);

        public DynamicChoicesBuilder<T> setShowInUsage(boolean var1);

        public ValueParameter<T> build();
    }

    public static interface StaticChoicesBuilder<T>
    extends ResettableBuilder<ValueParameter<T>, StaticChoicesBuilder<T>> {
        default public StaticChoicesBuilder<T> choice(String choice, T returnedObject) {
            return this.choices(Collections.singleton(choice), () -> returnedObject);
        }

        default public StaticChoicesBuilder<T> choices(Map<String, ? extends T> choices) {
            for (Map.Entry<String, T> entry : choices.entrySet()) {
                this.choice(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public StaticChoicesBuilder<T> choices(Iterable<String> var1, Supplier<? extends T> var2);

        public StaticChoicesBuilder<T> setShowInUsage(boolean var1);

        public ValueParameter<T> build();
    }

    public static interface CatalogedTypeBuilder<T extends CatalogType>
    extends ResettableBuilder<ValueParameter<T>, CatalogedTypeBuilder<T>> {
        public CatalogedTypeBuilder<T> defaultNamespace(String var1);

        public ValueParameter<T> build();
    }
}

