/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.persistence;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;

public interface DataView {
    public DataContainer getContainer();

    public DataQuery getCurrentPath();

    public String getName();

    public Optional<DataView> getParent();

    public Set<DataQuery> getKeys(boolean var1);

    public Map<DataQuery, Object> getValues(boolean var1);

    public boolean contains(DataQuery var1);

    public boolean contains(DataQuery var1, DataQuery ... var2);

    public Optional<Object> get(DataQuery var1);

    public DataView set(DataQuery var1, Object var2);

    public DataView remove(DataQuery var1);

    public DataView createView(DataQuery var1);

    public DataView createView(DataQuery var1, Map<?, ?> var2);

    public Optional<DataView> getView(DataQuery var1);

    public Optional<? extends Map<?, ?>> getMap(DataQuery var1);

    public Optional<Boolean> getBoolean(DataQuery var1);

    public Optional<Short> getShort(DataQuery var1);

    public Optional<Byte> getByte(DataQuery var1);

    public Optional<Integer> getInt(DataQuery var1);

    public Optional<Long> getLong(DataQuery var1);

    public Optional<Float> getFloat(DataQuery var1);

    public Optional<Double> getDouble(DataQuery var1);

    public Optional<String> getString(DataQuery var1);

    default public Optional<ResourceKey> getKey(DataQuery path) {
        Optional<String> value = this.getString(path);
        if (!value.isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(ResourceKey.resolve(value.get()));
        }
        catch (Exception ignore) {
            return Optional.empty();
        }
    }

    public Optional<List<?>> getList(DataQuery var1);

    public Optional<List<String>> getStringList(DataQuery var1);

    public Optional<List<Character>> getCharacterList(DataQuery var1);

    public Optional<List<Boolean>> getBooleanList(DataQuery var1);

    public Optional<List<Byte>> getByteList(DataQuery var1);

    public Optional<List<Short>> getShortList(DataQuery var1);

    public Optional<List<Integer>> getIntegerList(DataQuery var1);

    public Optional<List<Long>> getLongList(DataQuery var1);

    public Optional<List<Float>> getFloatList(DataQuery var1);

    public Optional<List<Double>> getDoubleList(DataQuery var1);

    public Optional<List<Map<?, ?>>> getMapList(DataQuery var1);

    public Optional<List<DataView>> getViewList(DataQuery var1);

    public <T extends DataSerializable> Optional<T> getSerializable(DataQuery var1, Class<T> var2);

    public <T extends DataSerializable> Optional<List<T>> getSerializableList(DataQuery var1, Class<T> var2);

    public <T> Optional<T> getObject(DataQuery var1, Class<T> var2);

    public <T> Optional<List<T>> getObjectList(DataQuery var1, Class<T> var2);

    public <T extends CatalogType> Optional<T> getCatalogType(DataQuery var1, Class<T> var2);

    public <T extends CatalogType> Optional<List<T>> getCatalogTypeList(DataQuery var1, Class<T> var2);

    public DataContainer copy();

    public DataContainer copy(SafetyMode var1);

    public boolean isEmpty();

    public SafetyMode getSafetyMode();

    public static enum SafetyMode {
        ALL_DATA_CLONED,
        CLONED_ON_SET,
        NO_DATA_CLONED;

    }
}

