/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.effect.particle;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.math.vector.Vector3d;

public interface ParticleEffect
extends DataSerializable {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public ParticleType getType();

    default public <V> Optional<V> getOption(Supplier<? extends ParticleOption<V>> option) {
        return this.getOption(option.get());
    }

    public <V> Optional<V> getOption(ParticleOption<V> var1);

    default public <V> Optional<V> getOptionOrDefault(Supplier<? extends ParticleOption<V>> option) {
        return this.getOptionOrDefault(option.get());
    }

    default public <V> Optional<V> getOptionOrDefault(ParticleOption<V> option) {
        Optional<V> value = this.getOption(option);
        return value.isPresent() ? value : this.getType().getDefaultOption(option);
    }

    public Map<ParticleOption<?>, Object> getOptions();

    public static interface Builder
    extends CopyableBuilder<ParticleEffect, Builder>,
    DataBuilder<ParticleEffect> {
        public Builder type(ParticleType var1);

        default public Builder type(Supplier<? extends ParticleType> particleType) {
            return this.type(particleType.get());
        }

        public <V> Builder option(ParticleOption<V> var1, V var2) throws IllegalArgumentException;

        default public <V> Builder option(Supplier<? extends ParticleOption<V>> option, V value) throws IllegalArgumentException {
            return this.option(option.get(), value);
        }

        default public Builder velocity(Vector3d velocity) {
            return this.option(ParticleOptions.VELOCITY, velocity);
        }

        default public Builder offset(Vector3d offset) {
            return this.option(ParticleOptions.OFFSET, offset);
        }

        default public Builder quantity(int quantity) throws IllegalArgumentException {
            return this.option(ParticleOptions.QUANTITY, Integer.valueOf(quantity));
        }

        public ParticleEffect build();
    }
}

