/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity.living;

import java.util.Optional;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.attribute.AttributeHolder;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.projectile.source.EntityProjectileSource;
import org.spongepowered.api.scoreboard.TeamMember;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.vector.Vector3d;

public interface Living
extends AttributeHolder,
Entity,
EntityProjectileSource,
TeamMember {
    default public Value.Mutable<Double> absorption() {
        return this.requireValue(Keys.ABSORPTION).asMutable();
    }

    default public Value.Mutable<ItemStackSnapshot> activeItem() {
        return this.requireValue(Keys.ACTIVE_ITEM).asMutable();
    }

    default public Value.Mutable<Double> health() {
        return this.requireValue(Keys.HEALTH).asMutable();
    }

    default public Value.Mutable<Double> maxHealth() {
        return this.requireValue(Keys.MAX_HEALTH).asMutable();
    }

    default public Value.Mutable<Entity> lastAttacker() {
        return this.requireValue(Keys.LAST_ATTACKER).asMutable();
    }

    default public Value.Mutable<Vector3d> headRotation() {
        return this.requireValue(Keys.HEAD_ROTATION).asMutable();
    }

    default public Value<Double> eyeHeight() {
        return this.requireValue(Keys.EYE_HEIGHT);
    }

    default public Value<Vector3d> eyePosition() {
        return this.requireValue(Keys.EYE_POSITION);
    }

    default public Optional<Value<Double>> lastDamageReceived() {
        return this.getValue(Keys.LAST_DAMAGE_RECEIVED);
    }

    default public Value.Mutable<Integer> maxAir() {
        return this.requireValue(Keys.MAX_AIR).asMutable();
    }

    default public Value.Mutable<Integer> remainingAir() {
        return this.requireValue(Keys.REMAINING_AIR).asMutable();
    }

    default public Value.Mutable<Integer> stuckArrows() {
        return this.requireValue(Keys.STUCK_ARROWS).asMutable();
    }

    default public Value.Mutable<Double> walkingSpeed() {
        return this.requireValue(Keys.WALKING_SPEED).asMutable();
    }

    public void lookAt(Vector3d var1);

    default public Vector3d getHeadDirection() {
        Vector3d headRotation = (Vector3d)this.headRotation().get();
        return Quaterniond.fromAxesAnglesDeg((double)headRotation.getX(), (double)(-headRotation.getY()), (double)headRotation.getZ()).getDirection();
    }
}

