/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.CopyableBuilder;

public interface DamageModifier {
    public static Builder builder() {
        return new Builder();
    }

    public DamageModifierType getType();

    public Cause getCause();

    public Optional<ItemStackSnapshot> getContributingItem();

    public static final class Builder
    implements CopyableBuilder<DamageModifier, Builder> {
        @Nullable DamageModifierType type;
        @Nullable Cause cause;
        @Nullable ItemStackSnapshot snapshot;

        Builder() {
        }

        public Builder type(Supplier<? extends DamageModifierType> damageModifierType) {
            return this.type(damageModifierType.get());
        }

        public Builder type(DamageModifierType damageModifierType) {
            this.type = Objects.requireNonNull(damageModifierType);
            return this;
        }

        public Builder item(ItemStack itemStack) {
            this.item(Objects.requireNonNull(itemStack, "ItemStack").createSnapshot());
            return this;
        }

        public Builder item(ItemStackSnapshot snapshot) {
            this.snapshot = Objects.requireNonNull(snapshot, "ItemStackSnapshot");
            return this;
        }

        public Builder cause(Cause cause) {
            this.cause = Objects.requireNonNull(cause);
            return this;
        }

        public DamageModifier build() {
            if (this.type == null) {
                throw new IllegalStateException("The DamageModifierType must not be null!");
            }
            if (this.cause == null) {
                throw new IllegalStateException("The cause for the DamageModifier must not be null!");
            }
            return new ImplementedDamageModifier(this);
        }

        @Override
        public Builder from(DamageModifier value) {
            this.type = value.getType();
            this.cause = value.getCause();
            this.snapshot = value.getContributingItem().orElse(null);
            return this;
        }

        @Override
        public Builder reset() {
            this.type = null;
            this.cause = null;
            return this;
        }

        private static class ImplementedDamageModifier
        implements DamageModifier {
            private final DamageModifierType type;
            private final Cause cause;
            private final @Nullable ItemStackSnapshot snapshot;

            ImplementedDamageModifier(Builder builder) {
                this.type = Objects.requireNonNull(builder.type, "DamageType is null!");
                this.cause = Objects.requireNonNull(builder.cause, "Cause is null!");
                this.snapshot = builder.snapshot;
            }

            @Override
            public DamageModifierType getType() {
                return this.type;
            }

            @Override
            public Cause getCause() {
                return this.cause;
            }

            @Override
            public Optional<ItemStackSnapshot> getContributingItem() {
                return Optional.ofNullable(this.snapshot);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.cause);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                ImplementedDamageModifier other = (ImplementedDamageModifier)obj;
                return Objects.equals(this.type, other.type) && Objects.equals(this.cause, other.cause) && Objects.equals(this.snapshot, other.snapshot);
            }

            public String toString() {
                return new StringJoiner(", ", "DamageModifier[", "]").add("type=" + this.type).add("cause=" + this.cause).add("snapshot=" + this.snapshot).toString();
            }
        }
    }
}

